/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.vareditor.variable.MultiplierSelectEditorVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class VariableUtil {
    public static ListCellRenderer createDropDownRenderer(final Variable var, final Color invalidColor) {
        return new BasicComboBoxRenderer(){

            @Override
            public void paint(Graphics g) {
                JComboBox combo = GuiUtil.getClosestParentOfClass(this, JComboBox.class);
                if (combo != null && !combo.isEnabled() && !var.isValueValid()) {
                    this.setBackground(invalidColor);
                }
                super.paint(g);
            }
        };
    }

    public static boolean currentValueIsTreeDefinedField(ClassRepository rep, Variable var) {
        boolean tdf;
        if (var == null) {
            tdf = false;
        } else if (var instanceof ValueFieldVariable) {
            ValueFieldVariable vfv = (ValueFieldVariable)var;
            if (vfv.inFieldMode()) {
                ValueFieldCompositeObject vfco = (ValueFieldCompositeObject)vfv.getValueObject();
                String fieldName = vfco.getFieldOrValueAsString();
                tdf = VariableUtil.isTDF(rep, fieldName);
            } else {
                tdf = false;
            }
        } else {
            String field = var.getValueString();
            tdf = VariableUtil.isTDF(rep, field);
        }
        return tdf;
    }

    public static boolean areVariablesEqual(Variable var1, Variable var2) {
        if (var1 == null || var2 == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
        boolean variablesAreEqual = true;
        if (!var1.getClass().equals(var2.getClass())) {
            variablesAreEqual = false;
        } else if (!var1.getLabel().equals(var2.getLabel())) {
            variablesAreEqual = false;
        } else {
            String var1ValueString = var1.getValueString();
            String var2ValueString = var2.getValueString();
            if (var1 instanceof MultiplierSelectEditorVariable && var2 instanceof MultiplierSelectEditorVariable) {
                var1ValueString = var1.getMultipleSelectValueString();
                var2ValueString = var2.getMultipleSelectValueString();
            }
            variablesAreEqual = var1ValueString == null ? var2ValueString == null : var1ValueString.equals(var2ValueString);
        }
        return variablesAreEqual;
    }

    private static boolean isTDF(ClassRepository rep, String field) {
        FieldDefinition fd = rep.getFieldDefinitionByName(field);
        return fd != null && "INTERNAL".equals(fd.getParameterType());
    }
}

