/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import ericsson.ere.exception.NotImplementedException;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import ericsson.vareditor.variable.array.GroupedObjectArrayEditor;
import ericsson.vareditor.variable.array.ObjectArrayModel;
import java.io.PrintWriter;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GroupedObjectArrayVariable
extends PanelVariable
implements TableModelListener {
    protected String myLabel;
    private ObjectArrayModel myModel;

    public GroupedObjectArrayVariable(String label, ObjectArrayModel model) {
        super(label);
        this.myLabel = label;
        this.myModel = model;
        this.myModel.addTableModelListener(this);
    }

    @Override
    public Object getModel() {
        return this.myModel;
    }

    @Override
    public String getValueString() {
        StringBuffer buf = new StringBuffer("<ObjectArrayVariable>\n");
        buf.append(this.myModel.getXml());
        buf.append("\n</ObjectArrayVariable>");
        return buf.toString();
    }

    @Override
    public String getTypename() {
        return "ObjectArray";
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        return new GroupedObjectArrayEditor(this.myLabel, this.myModel);
    }

    @Override
    public Object clone() {
        throw new NotImplementedException();
    }

    @Override
    public int getFormat() {
        return 0;
    }

    public Class<ObjectArrayModel> getValueClass() {
        return ObjectArrayModel.class;
    }

    @Override
    public Object getValueObject() {
        return this.getValueString();
    }

    @Override
    public void initFromXml(Node node, String value, String key, int format) {
        this.setKey(key);
        this.myModel.initData((Element)node);
    }

    @Override
    protected void validate() {
        this.setValid(true);
    }

    @Override
    public void setVarValue(String v) {
        this.setVarValue((Object)v);
    }

    @Override
    public void setVarValue(Object v) {
        if (v instanceof String) {
            if (((String)v).trim().length() == 0) {
                return;
            }
            try {
                this.myModel.initData(XMLUtil.buildDocumentFromString((String)v).getDocumentElement());
                return;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (v instanceof Object[]) {
            Object[] valuesToAdd = (Object[])v;
            int rowsToDelete = this.myModel.getRowCount();
            for (int ii = 0; ii < rowsToDelete; ++ii) {
                this.myModel.removeRow(0);
            }
            Object[] objToAdd = new Object[1];
            for (int ii = 0; ii < valuesToAdd.length; ++ii) {
                objToAdd[0] = valuesToAdd[ii];
                this.myModel.addRow(objToAdd);
            }
        } else if (v instanceof ObjectArrayModel) {
            this.myModel = (ObjectArrayModel)v;
        }
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
        out.print("<ObjectArrayVariable>\n");
        out.print(this.myModel.getXml());
        out.print("\n</ObjectArrayVariable>");
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.validate();
        this.fireValueChanged();
    }

    public Object getObjectArrayModel() {
        return this.myModel;
    }

    @Override
    protected String getXMLValueString() {
        return "";
    }
}

