/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.UIManager;

public class BevelArrowIcon
implements Icon {
    public static final int UP = 0;
    public static final int DOWN = 1;
    private static final int DEFAULT_SIZE = 11;
    private Color edge1;
    private Color edge2;
    private Color fillColor;
    private int arrowSize;
    private int direction;

    public BevelArrowIcon(int direction, boolean isRaisedView, boolean isPressedView) {
        if (isRaisedView) {
            if (isPressedView) {
                this.init(UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlShadow"), 11, direction);
            } else {
                this.init(UIManager.getColor("controlHighlight"), UIManager.getColor("controlShadow"), UIManager.getColor("control"), 11, direction);
            }
        } else if (isPressedView) {
            this.init(UIManager.getColor("controlDkShadow"), UIManager.getColor("controlLtHighlight"), UIManager.getColor("controlShadow"), 11, direction);
        } else {
            this.init(UIManager.getColor("controlShadow"), UIManager.getColor("controlHighlight"), UIManager.getColor("control"), 11, direction);
        }
    }

    public BevelArrowIcon(Color edge1, Color edge2, Color fill, int size, int direction) {
        this.init(edge1, edge2, fill, size, direction);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        switch (this.direction) {
            case 1: {
                this.drawDescendArrow(g, x, y);
                break;
            }
            case 0: {
                this.drawAscendArrow(g, x, y);
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.arrowSize;
    }

    @Override
    public int getIconHeight() {
        return this.arrowSize;
    }

    private void init(Color e1, Color e2, Color fill, int size, int dir) {
        this.edge1 = e1;
        this.edge2 = e2;
        this.fillColor = fill;
        this.arrowSize = size;
        this.direction = dir;
    }

    private void drawDescendArrow(Graphics graphics, int xo, int yo) {
        graphics.setColor(this.edge1);
        graphics.drawLine(xo, yo, xo + this.arrowSize - 1, yo);
        graphics.drawLine(xo, yo + 1, xo + this.arrowSize - 3, yo + 1);
        graphics.setColor(this.edge2);
        graphics.drawLine(xo + this.arrowSize - 2, yo + 1, xo + this.arrowSize - 1, yo + 1);
        int x = xo + 1;
        int y = yo + 2;
        int dx = this.arrowSize - 6;
        while (y + 1 < yo + this.arrowSize) {
            graphics.setColor(this.edge1);
            graphics.drawLine(x, y, x + 1, y);
            graphics.drawLine(x, y + 1, x + 1, y + 1);
            if (0 < dx) {
                graphics.setColor(this.fillColor);
                graphics.drawLine(x + 2, y, x + 1 + dx, y);
                graphics.drawLine(x + 2, y + 1, x + 1 + dx, y + 1);
            }
            graphics.setColor(this.edge2);
            graphics.drawLine(x + dx + 2, y, x + dx + 3, y);
            graphics.drawLine(x + dx + 2, y + 1, x + dx + 3, y + 1);
            ++x;
            y += 2;
            dx -= 2;
        }
        graphics.setColor(this.edge1);
        graphics.drawLine(xo + this.arrowSize / 2, yo + this.arrowSize - 1, xo + this.arrowSize / 2, yo + this.arrowSize - 1);
    }

    private void drawAscendArrow(Graphics graphics, int xo, int yo) {
        graphics.setColor(this.edge1);
        int x = xo + this.arrowSize / 2;
        graphics.drawLine(x, yo, x, yo);
        --x;
        int y = yo + 1;
        int dx = 0;
        while (y + 3 < yo + this.arrowSize) {
            graphics.setColor(this.edge1);
            graphics.drawLine(x, y, x + 1, y);
            graphics.drawLine(x, y + 1, x + 1, y + 1);
            if (0 < dx) {
                graphics.setColor(this.fillColor);
                graphics.drawLine(x + 2, y, x + 1 + dx, y);
                graphics.drawLine(x + 2, y + 1, x + 1 + dx, y + 1);
            }
            graphics.setColor(this.edge2);
            graphics.drawLine(x + dx + 2, y, x + dx + 3, y);
            graphics.drawLine(x + dx + 2, y + 1, x + dx + 3, y + 1);
            --x;
            y += 2;
            dx += 2;
        }
        graphics.setColor(this.edge1);
        graphics.drawLine(xo, yo + this.arrowSize - 3, xo + 1, yo + this.arrowSize - 3);
        graphics.setColor(this.edge2);
        graphics.drawLine(xo + 2, yo + this.arrowSize - 2, xo + this.arrowSize - 1, yo + this.arrowSize - 2);
        graphics.drawLine(xo, yo + this.arrowSize - 1, xo + this.arrowSize, yo + this.arrowSize - 1);
    }
}

