/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.bitpatternutils.BPListObject;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditAction;
import ericsson.vareditor.variable.bitpatternutils.BitPatternPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class BitPatternButtonVariablePanel
extends AbstractPanelVariableEditor
implements ActionListener {
    private JTextField myModifyTextField;
    private DataType myDataType;
    private BPListObject myModel;
    private static BitPatternEditAction editAction = null;
    protected static final String LBL_DIALOG_TITLE = "Bit pattern value";
    protected JDialog myEditDialog;
    protected BitPatternPanel myEditPanel;

    public BitPatternButtonVariablePanel(String value, DataType dataType) {
        this.myDataType = dataType;
        this.handleInput(value);
        this.init();
    }

    private void handleInput(String value) {
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.hasMoreTokens()) {
            this.myModel = new BPListObject(tokenizer.nextToken(), this.myDataType);
        }
        if (value.equals("")) {
            this.myModel = new BPListObject("0", this.myDataType);
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.myModifyTextField = new JTextField(this.myModel.toString());
        this.myModifyTextField.setToolTipText(this.myModel.toString());
        this.myModifyTextField.setEditable(false);
        this.myModifyTextField.setPreferredSize(new Dimension(50, 20));
        JButton modifyButton = new JButton();
        modifyButton.setName("BitPatternButtonVariablePanel.JButton.Modify");
        modifyButton.setPreferredSize(new Dimension(28, 23));
        modifyButton.setIcon(RmaDefs.getImageIcon("new_edit.gif"));
        modifyButton.setToolTipText("Modify the Bit pattern");
        this.add((Component)this.myModifyTextField, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)modifyButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        JFrame frame = GuiServiceCenter.getInstance().getMainWindow();
        this.myEditDialog = new JDialog(frame, LBL_DIALOG_TITLE, true);
        this.myEditDialog.setMinimumSize(new Dimension(600, 285));
        this.myEditPanel = new BitPatternPanel(this.myModel.sourceString(), this.myDataType, false);
        this.myEditPanel.addOkActionListener(this);
        this.myEditPanel.addCancelActionListener(this);
        this.myEditDialog.getContentPane().add(this.myEditPanel);
        this.myEditDialog.pack();
        editAction = new BitPatternEditAction(this);
        modifyButton.addActionListener(editAction);
    }

    @Override
    public Object getEditorValue() {
        return this.getValueString();
    }

    protected BPListObject getModel() {
        return this.myModel;
    }

    @Override
    public boolean isEditorValueValid() {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("OK")) {
            if (!this.myModel.sourceString().equals(this.myEditPanel.getValue())) {
                this.setValue(this.myEditPanel.getValue());
                this.myEditDialog.dispose();
                this.fireDataChanged();
            } else {
                this.myEditDialog.setVisible(false);
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.myEditDialog.dispose();
            this.myEditPanel.reset();
        }
    }

    public void setValue(String value) {
        this.myModel = new BPListObject(value, this.myDataType);
        this.myModifyTextField.setText(this.myModel.toString());
        this.myModifyTextField.setToolTipText(this.myModel.toString());
    }

    public String getValueString() {
        return this.myModel.sourceString();
    }

    public Object getValueObject() {
        return this.myModel;
    }
}

