/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.vareditor.variable.bitpatternutils.BitPatternEditorDocument;
import ericsson.vareditor.variable.bitpatternutils.BitPatternInputVariablePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BitPatternEditorDialog
extends JDialog
implements ItemListener {
    private boolean TFEdited = false;
    private JTextField myDecimalTF;
    private JLabel myDecimalLabel;
    private static JLabel my64to57Label = new JLabel("64..57");
    private static JLabel my56to49Label = new JLabel("56..49");
    private static JLabel my48to41Label = new JLabel("48..41");
    private static JLabel my40to33Label = new JLabel("40..33");
    private static JLabel my32to25Label = new JLabel("32..25");
    private static JLabel my24to17Label = new JLabel("24..17");
    private static JLabel my16to9Label = new JLabel("16..9");
    private static JLabel my8to1Label = new JLabel("8..1");
    private JCheckBox[] myCheckBoxes = new JCheckBox[64];
    private BigInteger myValue = new BigInteger("0");
    private final String ALL_SELECTED = "-1";
    private final String NONE_SELECTED = "0";
    private int myDataType;
    private int numOfBits;

    public BitPatternEditorDialog(JFrame owner, BigInteger aStartValue, BitPatternInputVariablePanel aPanel, int dataType) {
        super((Frame)owner, true);
        this.myDataType = dataType;
        this.setTitle("Edit Bit pattern");
        this.setDefaultCloseOperation(2);
        this.buildMainPanel();
        this.myDecimalTF.setText(aStartValue.toString());
        this.setCheckBoxes(aStartValue.toString());
    }

    private void buildMainPanel() {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        this.buildDecimalPanel(aPanel);
        this.buildBitPatternPanel(aPanel);
        this.buildButtonPanel(aPanel);
        this.setResizable(false);
    }

    private void buildDecimalPanel(JPanel aPanel) {
        JPanel decimalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.myDecimalLabel = new JLabel("Decimal:");
        decimalPanel.add((Component)this.myDecimalLabel, gbc);
        this.myDecimalTF = new JTextField();
        this.myDecimalTF.setColumns(13);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        decimalPanel.add((Component)this.myDecimalTF, gbc);
        aPanel.add((Component)decimalPanel, "North");
        this.myDecimalTF.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        e.consume();
                        BitPatternEditorDialog.this.dispose();
                        break;
                    }
                    case 27: {
                        e.consume();
                        BitPatternEditorDialog.this.dispose();
                        return;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                BitPatternEditorDialog.this.TFEdited = true;
                BitPatternEditorDialog.this.setCheckBoxes(BitPatternEditorDialog.this.myDecimalTF.getText());
                BitPatternEditorDialog.this.TFEdited = false;
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private void buildBitPatternPanel(JPanel aPanel) {
        switch (this.myDataType) {
            case 0: {
                this.buildShortBitPatternPanel(aPanel);
                this.numOfBits = 16;
                break;
            }
            case 1: {
                this.buildIntBitPatternPanel(aPanel);
                this.numOfBits = 32;
                break;
            }
            default: {
                this.buildLongBitPatternPanel(aPanel);
                this.numOfBits = 64;
            }
        }
    }

    private void buildShortBitPatternPanel(JPanel aPanel) {
        JPanel bitPatternPanel = new JPanel(new GridBagLayout());
        this.myDecimalTF.setDocument(new BitPatternEditorDocument(BigInteger.ZERO, BigInteger.TEN));
        this.createBitPatternPanel(bitPatternPanel, my16to9Label, 0, 15);
        this.createBitPatternPanel(bitPatternPanel, my8to1Label, 1, 7);
        aPanel.add((Component)bitPatternPanel, "Center");
    }

    private void buildIntBitPatternPanel(JPanel aPanel) {
        JPanel bitPatternPanel = new JPanel(new GridBagLayout());
        this.myDecimalTF.setDocument(new BitPatternEditorDocument(BigInteger.ZERO, BigInteger.TEN));
        this.createBitPatternPanel(bitPatternPanel, my32to25Label, 0, 31);
        this.createBitPatternPanel(bitPatternPanel, my24to17Label, 1, 23);
        this.createBitPatternPanel(bitPatternPanel, my16to9Label, 2, 15);
        this.createBitPatternPanel(bitPatternPanel, my8to1Label, 3, 7);
        aPanel.add((Component)bitPatternPanel, "Center");
    }

    private void buildLongBitPatternPanel(JPanel aPanel) {
        JPanel bitPatternPanel = new JPanel(new GridBagLayout());
        this.myDecimalTF.setDocument(new BitPatternEditorDocument(BigInteger.ZERO, BigInteger.TEN));
        this.createBitPatternPanel(bitPatternPanel, my64to57Label, 0, 63);
        this.createBitPatternPanel(bitPatternPanel, my56to49Label, 1, 55);
        this.createBitPatternPanel(bitPatternPanel, my48to41Label, 2, 47);
        this.createBitPatternPanel(bitPatternPanel, my40to33Label, 3, 39);
        this.createBitPatternPanel(bitPatternPanel, my32to25Label, 4, 31);
        this.createBitPatternPanel(bitPatternPanel, my24to17Label, 5, 23);
        this.createBitPatternPanel(bitPatternPanel, my16to9Label, 6, 15);
        this.createBitPatternPanel(bitPatternPanel, my8to1Label, 7, 7);
        aPanel.add((Component)bitPatternPanel, "Center");
    }

    private void buildButtonPanel(JPanel aPanel) {
        JPanel buttonPanel = new JPanel(new GridLayout());
        JButton selectAll = new JButton("Select All");
        selectAll.addKeyListener(this.createKeyListener());
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                BitPatternEditorDialog.this.myDecimalTF.setText("-1");
                BitPatternEditorDialog.this.setCheckBoxes("-1");
            }
        });
        JButton deselectAll = new JButton("Deselect All");
        deselectAll.addKeyListener(this.createKeyListener());
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                BitPatternEditorDialog.this.myDecimalTF.setText("0");
                BitPatternEditorDialog.this.setCheckBoxes("0");
            }
        });
        buttonPanel.add(selectAll);
        buttonPanel.add(deselectAll);
        aPanel.add((Component)buttonPanel, "South");
    }

    private void createBitPatternPanel(JPanel aPanel, JLabel aLabel, int yValue, int startBit) {
        GridBagConstraints gdc = new GridBagConstraints();
        gdc.gridy = yValue;
        aPanel.add((Component)aLabel, gdc);
        int xValue = 1;
        for (int i = startBit; i > startBit - 8; --i) {
            gdc.gridx = xValue++;
            this.myCheckBoxes[i] = new JCheckBox();
            this.myCheckBoxes[i].addItemListener(this);
            this.myCheckBoxes[i].addKeyListener(this.createKeyListener());
            aPanel.add((Component)this.myCheckBoxes[i], gdc);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent anEvent) {
        if (!this.TFEdited) {
            StringBuilder tempString = new StringBuilder();
            for (int i = 0; i < this.numOfBits; ++i) {
                if (this.myCheckBoxes[i].isSelected()) {
                    tempString.insert(0, '1');
                    continue;
                }
                tempString.insert(0, '0');
            }
            this.setValue(tempString.toString());
            this.myDecimalTF.setText(this.myValue.toString());
        }
    }

    private void setValue(String aValue) {
        BigInteger tempBI = new BigInteger(aValue, 2);
        switch (this.myDataType) {
            case 0: {
                this.myValue = new BigInteger(Short.valueOf(tempBI.shortValue()).toString());
                break;
            }
            case 1: {
                this.myValue = new BigInteger(Integer.valueOf(tempBI.intValue()).toString());
                break;
            }
            default: {
                this.myValue = new BigInteger(Long.valueOf(tempBI.longValue()).toString());
            }
        }
    }

    private void setCheckBoxes(String valueString) {
        if (valueString.length() != 0 && !valueString.equals("-")) {
            BigInteger theValue = new BigInteger(valueString);
            for (int i = 0; i < this.numOfBits; ++i) {
                this.myCheckBoxes[i].setSelected(theValue.testBit(i));
            }
        }
    }

    private KeyListener createKeyListener() {
        KeyListener aKeyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyCode()) {
                    case 10: {
                        e.consume();
                        BitPatternEditorDialog.this.dispose();
                        break;
                    }
                    case 27: {
                        e.consume();
                        BitPatternEditorDialog.this.dispose();
                        return;
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        return aKeyListener;
    }
}

