/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import java.math.BigInteger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BitPatternEditorDocument
extends PlainDocument
implements FieldValidation {
    public static final BigInteger BIGINT_ZERO = new BigInteger("0");
    private BigInteger myMin;
    private BigInteger myMax;
    private boolean allowEmpty = true;
    private boolean isEnabled = true;
    private boolean isNegative = false;

    public BitPatternEditorDocument(BigInteger min, BigInteger max) {
        this.myMin = min;
        this.myMax = max;
        if (this.myMin.compareTo(BIGINT_ZERO) < 0) {
            this.isNegative = true;
        }
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        String numbersOnlyString = "";
        int start = 0;
        if (str != null && str.length() > 0) {
            char[] chars = str.toCharArray();
            for (int i = start; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) {
                    numbersOnlyString = numbersOnlyString + chars[i];
                    continue;
                }
                if (chars[i] == '-' && this.isNegative) {
                    numbersOnlyString = numbersOnlyString + chars[i];
                    continue;
                }
                RmaDefs.getInstance().controlledBeep();
            }
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0) {
            if (this.allowEmpty) {
                super.insertString(offs, numbersOnlyString, a);
            }
            return;
        }
        if (proposedResult.equals("-")) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        try {
            BigInteger resultAsBigInt = new BigInteger(proposedResult);
            if (resultAsBigInt.compareTo(this.myMax) > 0 || resultAsBigInt.compareTo(this.myMin) < 0) {
                RmaDefs.getInstance().controlledBeep();
                return;
            }
        }
        catch (Exception e) {
            RmaDefs.getInstance().controlledBeep();
            return;
        }
        super.insertString(offs, numbersOnlyString, a);
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (value.equals("")) {
                return this.allowEmpty;
            }
            BigInteger valueAsBigInt = new BigInteger(value);
            if (valueAsBigInt.compareTo(this.myMax) > 0 || valueAsBigInt.compareTo(this.myMin) < 0) {
                return false;
            }
            RmaDefs.getInstance().controlledBeep();
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }
}

