/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import java.math.BigInteger;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class BitPatternFieldDocument
extends PlainDocument
implements FieldValidation {
    public static final BigInteger MAX_ULONG = new BigInteger("9223372036854775807").multiply(new BigInteger("2")).add(new BigInteger("1"));
    public static final BigInteger MAX_UINT = new BigInteger("2147483647").multiply(new BigInteger("2")).add(new BigInteger("1"));
    public static final BigInteger MAX_USHORT = new BigInteger("32767").multiply(new BigInteger("2")).add(new BigInteger("1"));
    public static final BigInteger BIGINT_ZERO = new BigInteger("0");
    private BigInteger myMax = MAX_ULONG;
    private boolean allowEmpty = true;
    private boolean isEnabled = true;
    private StatusPanel myStatusPanel;

    public BitPatternFieldDocument(BigInteger max, StatusPanel aStatusPanel) {
        this.myMax = max;
        this.myStatusPanel = aStatusPanel;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.isEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        StatusPanel.getInstance().setStatusMsg("");
        String numbersOnlyString = "";
        int start = 0;
        if (str != null && str.length() > 0) {
            char[] chars = str.toCharArray();
            for (int i = start; i < chars.length; ++i) {
                if (Character.isDigit(chars[i])) {
                    numbersOnlyString = numbersOnlyString + chars[i];
                    continue;
                }
                RmaDefs.getInstance().controlledBeep();
                if (this.myStatusPanel == null) continue;
                this.myStatusPanel.setStatusMsg("Only digits '0-9' allowed");
            }
        }
        String currentText = this.getText(0, this.getLength());
        String beforeOffset = currentText.substring(0, offs);
        String afterOffset = currentText.substring(offs, currentText.length());
        String proposedResult = beforeOffset + numbersOnlyString + afterOffset;
        if (proposedResult.length() == 0 && this.allowEmpty) {
            super.insertString(offs, numbersOnlyString, a);
            return;
        }
        if (proposedResult.length() == 0) {
            return;
        }
        BigInteger resultAsBigInt = new BigInteger(proposedResult);
        if (resultAsBigInt.compareTo(this.myMax) > 0) {
            RmaDefs.getInstance().controlledBeep();
            if (this.myStatusPanel != null) {
                this.myStatusPanel.setStatusMsg("Number out of range, maximum value: " + this.myMax);
            }
            return;
        }
        super.insertString(offs, numbersOnlyString, a);
    }

    @Override
    public void enableValidation(boolean enable) {
        this.isEnabled = enable;
    }

    @Override
    public boolean isValid(String value) {
        try {
            if (value.equals("")) {
                return this.allowEmpty;
            }
            BigInteger valueAsBigInt = new BigInteger(value);
            if (valueAsBigInt.compareTo(this.myMax) <= 0) {
                return true;
            }
            RmaDefs.getInstance().controlledBeep();
            if (this.myStatusPanel != null) {
                this.myStatusPanel.setStatusMsg("Number out of range, maximum value: " + this.myMax);
            }
            return false;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
    }
}

