/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import com.ericsson.ere.gui.util.ClosableVarPanel;
import ericsson.vareditor.LabelRenderer2;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.BitPatternInputVariable;
import ericsson.vareditor.variable.bitpatternutils.BitPatternEditorDocument;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BitPatternInputVariablePanel
extends AbstractPanelVariableEditor {
    private boolean TFEdited = false;
    private JLabel myDecimalLabel;
    private JTextField myDecimalTF;
    private JLabel mySelectionLabel;
    private JCheckBox mySelectionCB;
    private JLabel[] bitLabelsLittleEnd = new JLabel[]{new JLabel("8..1"), new JLabel("16..9"), new JLabel("24..17"), new JLabel("32..25"), new JLabel("40..33"), new JLabel("48..41"), new JLabel("56..49"), new JLabel("64..57")};
    private JLabel[] bitLabelsBigEnd = new JLabel[]{new JLabel("1..8"), new JLabel("9..16"), new JLabel("17..24"), new JLabel("25..32"), new JLabel("33..40"), new JLabel("41..48"), new JLabel("49..56"), new JLabel("57..64")};
    private JPanel bitPatternPanel = new JPanel();
    private JPanel littleEndPanel = new JPanel();
    private JPanel bigEndPanel = new JPanel();
    private JCheckBox[] myLittleCheckBoxes = new JCheckBox[64];
    private JCheckBox[] myBigCheckBoxes = new JCheckBox[64];
    private final String NONE_SELECTED = "0";
    public static final int SHORT = 0;
    public static final int INTEGER = 1;
    public static final int LONG = 2;
    public static final int USHORT = 3;
    public static final int UINTEGER = 4;
    public static final int ULONG = 5;
    private static final String TEXT_TO_SCIENTIFIC = "Switch to scientific mode";
    private static final String TEXT_TO_NORMAL = "Switch to normal mode";
    private static final String ALL_ZEROS = "0000000000000000000000000000000000000000000000000000000000000000";
    private int numOfBits;
    private int myDataType;
    private BitPatternInputVariable myVariable = null;
    private BigInteger myMin;
    private BigInteger myMax;
    private BigInteger allSelected = new BigInteger("-1");
    private String binaryRep;
    private boolean isFoldable;

    public BitPatternInputVariablePanel(BitPatternInputVariable var) {
        this(var, true);
    }

    public BitPatternInputVariablePanel(BitPatternInputVariable aVar, boolean foldable) {
        this.myVariable = aVar;
        this.isFoldable = foldable;
        this.myDataType = aVar.myDataType;
        switch (this.myDataType) {
            case 3: {
                this.numOfBits = 16;
                this.myMin = new BigInteger("0");
                this.allSelected = this.myMax = new BigInteger("65535");
                this.binaryRep = "Binary: 00000000.00000000";
                break;
            }
            case 0: {
                this.numOfBits = 16;
                this.myMin = new BigInteger("-32768");
                this.myMax = new BigInteger("32767");
                this.binaryRep = "Binary: 00000000.00000000";
                break;
            }
            case 4: {
                this.numOfBits = 32;
                this.myMin = new BigInteger("0");
                this.allSelected = this.myMax = new BigInteger("4294967295");
                this.binaryRep = "Binary: 00000000.00000000.00000000.00000000";
                break;
            }
            case 1: {
                this.numOfBits = 32;
                this.myMin = new BigInteger("-2147483648");
                this.myMax = new BigInteger("2147483647");
                this.binaryRep = "Binary: 00000000.00000000.00000000.00000000";
                break;
            }
            case 5: {
                this.numOfBits = 64;
                this.myMin = new BigInteger("0");
                this.allSelected = this.myMax = new BigInteger("18446744073709551615");
                this.binaryRep = "Binary: 00000000.00000000.00000000.00000000.00000000.00000000.00000000.00000000";
                break;
            }
            default: {
                this.numOfBits = 64;
                this.myMin = new BigInteger("-9223372036854775808");
                this.myMax = new BigInteger("9223372036854775807");
                this.binaryRep = "Binary: 00000000.00000000.00000000.00000000.00000000.00000000.00000000.00000000";
            }
        }
        this.buildPanel();
    }

    private void buildPanel() {
        this.setLayout(new GridBagLayout());
        if (this.isFoldable) {
            this.add((Component)this.buildFoldableMainPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 5, 0), 0, 0));
        } else {
            this.add((Component)this.buildNormalMainPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 10, 0), 0, 0));
        }
        this.myDecimalTF.setText(this.myVariable.getValueString());
        this.changeBitPanel(false);
    }

    private ClosableVarPanel buildFoldableMainPanel() {
        LabelRenderer2 myRenderer = new LabelRenderer2(this.myVariable, true);
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new GridBagLayout());
        this.buildDecimalPanel(aPanel);
        this.buildBitPatternPanel(aPanel);
        this.buildButtonPanel(aPanel);
        JPanel wrappingPanel = new JPanel(new GridBagLayout());
        wrappingPanel.add((Component)aPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        wrappingPanel.add((Component)new JPanel(), new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        ArrayList<JPanel> l = new ArrayList<JPanel>();
        l.add(wrappingPanel);
        return new ClosableVarPanel(myRenderer, true, l, true);
    }

    private JPanel buildNormalMainPanel() {
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new GridBagLayout());
        aPanel.setMinimumSize(new Dimension(232, 1));
        this.buildDecimalPanel(aPanel);
        this.buildBitPatternPanel(aPanel);
        this.buildButtonPanel(aPanel);
        JPanel wrappingPanel = new JPanel(new BorderLayout());
        wrappingPanel.add((Component)aPanel, "West");
        return wrappingPanel;
    }

    private void buildDecimalPanel(JPanel aPanel) {
        JPanel decimalPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.myDecimalLabel = new JLabel("Decimal:");
        this.myDecimalLabel.setToolTipText(this.binaryRep);
        decimalPanel.add((Component)this.myDecimalLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.myDecimalTF = new JTextField();
        this.myDecimalTF.setToolTipText(this.binaryRep);
        this.myDecimalTF.setColumns(13);
        this.myDecimalTF.setHorizontalAlignment(4);
        this.myDecimalTF.setDocument(new BitPatternEditorDocument(this.myMin, this.myMax));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        decimalPanel.add((Component)this.myDecimalTF, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.myDecimalTF.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                BitPatternInputVariablePanel.this.TFEdited = true;
                BitPatternInputVariablePanel.this.setCheckBoxes(BitPatternInputVariablePanel.this.myDecimalTF.getText());
                BitPatternInputVariablePanel.this.setValue(BitPatternInputVariablePanel.this.myDecimalTF.getText(), false);
                BitPatternInputVariablePanel.this.TFEdited = false;
                BitPatternInputVariablePanel.this.myVariable.update(BitPatternInputVariablePanel.this.myDecimalTF.getText(), true);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.mySelectionLabel = new JLabel("  S");
        this.mySelectionLabel.setToolTipText(TEXT_TO_SCIENTIFIC);
        gbc.gridx = 3;
        gbc.gridwidth = 1;
        decimalPanel.add((Component)this.mySelectionLabel, new GridBagConstraints(3, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.mySelectionCB = new JCheckBox();
        this.mySelectionCB.setToolTipText(TEXT_TO_SCIENTIFIC);
        gbc.gridx = 4;
        decimalPanel.add((Component)this.mySelectionCB, new GridBagConstraints(4, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 3, 0), 0, 0));
        this.mySelectionCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (BitPatternInputVariablePanel.this.mySelectionCB.isSelected()) {
                    BitPatternInputVariablePanel.this.changeBitPanel(true);
                    BitPatternInputVariablePanel.this.mySelectionLabel.setToolTipText(BitPatternInputVariablePanel.TEXT_TO_NORMAL);
                    BitPatternInputVariablePanel.this.mySelectionCB.setToolTipText(BitPatternInputVariablePanel.TEXT_TO_NORMAL);
                } else {
                    BitPatternInputVariablePanel.this.changeBitPanel(false);
                    BitPatternInputVariablePanel.this.mySelectionLabel.setToolTipText(BitPatternInputVariablePanel.TEXT_TO_SCIENTIFIC);
                    BitPatternInputVariablePanel.this.mySelectionCB.setToolTipText(BitPatternInputVariablePanel.TEXT_TO_SCIENTIFIC);
                }
                BitPatternInputVariablePanel.this.calculateBinary();
                BitPatternInputVariablePanel.this.myDecimalLabel.setToolTipText("Binary: " + BitPatternInputVariablePanel.this.binaryRep);
                BitPatternInputVariablePanel.this.myDecimalTF.setToolTipText("Binary: " + BitPatternInputVariablePanel.this.binaryRep);
            }
        });
        aPanel.add((Component)decimalPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private void buildBitPatternPanel(JPanel aPanel) {
        this.littleEndPanel.setLayout(new GridBagLayout());
        this.bigEndPanel.setLayout(new GridBagLayout());
        this.createBitPatternPanels();
        this.bitPatternPanel.add(this.bigEndPanel);
        aPanel.add((Component)this.bitPatternPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 0, new Insets(0, 0, 3, 0), 0, 0));
    }

    private void createBitPatternPanels() {
        int i;
        int xValue;
        GridBagConstraints gdc;
        int startBit;
        int yValue = 0;
        this.littleEndPanel.setLayout(new GridBagLayout());
        this.bigEndPanel.setLayout(new GridBagLayout());
        for (startBit = this.numOfBits - 1; startBit > 0; startBit -= 8) {
            gdc = new GridBagConstraints();
            xValue = 1;
            gdc.gridx = 0;
            this.littleEndPanel.add((Component)this.bitLabelsLittleEnd[startBit / 8], gdc);
            gdc.gridy = yValue;
            for (i = startBit; i > startBit - 8; --i) {
                gdc.gridx = xValue++;
                this.myLittleCheckBoxes[i] = new JCheckBox();
                this.myLittleCheckBoxes[i].addItemListener(this.createLittleItemListener());
                this.littleEndPanel.add((Component)this.myLittleCheckBoxes[i], gdc);
            }
            ++yValue;
        }
        yValue = 0;
        for (startBit = 0; startBit < this.numOfBits; startBit += 8) {
            gdc = new GridBagConstraints();
            xValue = 1;
            gdc.gridx = 0;
            this.bigEndPanel.add((Component)this.bitLabelsBigEnd[startBit / 8], gdc);
            gdc.gridy = yValue;
            for (i = startBit; i < startBit + 8; ++i) {
                gdc.gridx = xValue++;
                this.myBigCheckBoxes[i] = new JCheckBox();
                this.myBigCheckBoxes[i].addItemListener(this.createBigItemListener());
                this.bigEndPanel.add((Component)this.myBigCheckBoxes[i], gdc);
            }
            ++yValue;
        }
    }

    private void buildButtonPanel(JPanel aPanel) {
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JButton selectAll = new JButton("Select All");
        buttonPanel.add((Component)selectAll, gbc);
        selectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                BitPatternInputVariablePanel.this.myDecimalTF.setText(BitPatternInputVariablePanel.this.allSelected.toString());
                BitPatternInputVariablePanel.this.setCheckBoxes(BitPatternInputVariablePanel.this.allSelected.toString());
            }
        });
        JButton deselectAll = new JButton("Deselect All");
        gbc.gridx = 1;
        buttonPanel.add((Component)deselectAll, gbc);
        deselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent a) {
                BitPatternInputVariablePanel.this.myDecimalTF.setText("0");
                BitPatternInputVariablePanel.this.setCheckBoxes("0");
            }
        });
        aPanel.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 15, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    private ItemListener createLittleItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BitPatternInputVariablePanel.this.TFEdited) {
                    StringBuilder tempString = new StringBuilder();
                    for (int i = 0; i < BitPatternInputVariablePanel.this.numOfBits; ++i) {
                        if (BitPatternInputVariablePanel.this.myLittleCheckBoxes[i].isSelected()) {
                            tempString.insert(0, '1');
                            continue;
                        }
                        tempString.insert(0, '0');
                    }
                    BitPatternInputVariablePanel.this.setValue(tempString.toString(), true);
                    BitPatternInputVariablePanel.this.myDecimalTF.setText(BitPatternInputVariablePanel.this.myVariable.getValueString());
                }
            }
        };
    }

    private ItemListener createBigItemListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!BitPatternInputVariablePanel.this.TFEdited) {
                    StringBuilder tempString = new StringBuilder();
                    for (int i = 0; i < BitPatternInputVariablePanel.this.numOfBits; ++i) {
                        if (BitPatternInputVariablePanel.this.myBigCheckBoxes[i].isSelected()) {
                            tempString.insert(0, '1');
                            continue;
                        }
                        tempString.insert(0, '0');
                    }
                    BitPatternInputVariablePanel.this.setValue(tempString.toString(), true);
                    BitPatternInputVariablePanel.this.myDecimalTF.setText(BitPatternInputVariablePanel.this.myVariable.getValueString());
                }
            }
        };
    }

    private void changeBitPanel(boolean isLittleEnd) {
        this.setCheckBoxes(this.myDecimalTF.getText());
        this.bitPatternPanel.removeAll();
        if (isLittleEnd) {
            this.bitPatternPanel.add(this.littleEndPanel);
        } else {
            this.bitPatternPanel.add(this.bigEndPanel);
        }
        this.bitPatternPanel.validate();
        this.bitPatternPanel.repaint();
    }

    private void setValue(String aValue, boolean isBinary) {
        if (aValue.length() == 0 || aValue.equals("-")) {
            this.myVariable.update(new BigInteger("0"), true);
        } else if (isBinary) {
            this.myVariable.update(new BigInteger(aValue, 2), true);
        } else {
            this.myVariable.update(new BigInteger(aValue), true);
        }
        this.calculateBinary();
        this.myDecimalLabel.setToolTipText("Binary: " + this.binaryRep);
        this.myDecimalTF.setToolTipText("Binary: " + this.binaryRep);
    }

    private void calculateBinary() {
        String binaryString = Long.toBinaryString(((Number)this.myVariable.getValueObject()).longValue());
        this.binaryRep = binaryString.length() < this.numOfBits ? this.insertDots(ALL_ZEROS.substring(binaryString.length() + (64 - this.numOfBits)) + binaryString) : (binaryString.length() > this.numOfBits ? this.insertDots(binaryString.substring(this.numOfBits)) : this.insertDots(binaryString));
        if (!this.mySelectionCB.isSelected()) {
            StringBuilder tempString = new StringBuilder();
            for (int i = this.binaryRep.length() - 1; i >= 0; --i) {
                tempString.append(this.binaryRep.charAt(i));
            }
            this.binaryRep = tempString.toString();
        }
    }

    private String insertDots(String binaryString) {
        StringBuilder newString = new StringBuilder(binaryString);
        for (int i = 8; i < newString.length(); i += 8) {
            newString.insert(i++, '.');
        }
        return newString.toString();
    }

    private void setCheckBoxes(String valueString) {
        if (valueString.length() == 0 || valueString.equals("-")) {
            for (int i = 0; i < this.numOfBits; ++i) {
                this.myLittleCheckBoxes[i].setSelected(false);
                this.myBigCheckBoxes[i].setSelected(false);
            }
        } else {
            BigInteger theValue = new BigInteger(valueString);
            for (int i = 0; i < this.numOfBits; ++i) {
                this.myLittleCheckBoxes[i].setSelected(theValue.testBit(i));
                this.myBigCheckBoxes[i].setSelected(theValue.testBit(i));
            }
        }
    }

    @Override
    public Object getEditorValue() {
        if (this.myDataType == 0 || this.myDataType == 3) {
            return new Short(((BigInteger)this.myVariable.getValueObject()).shortValue());
        }
        if (this.myDataType == 1 || this.myDataType == 4) {
            return new Integer(((BigInteger)this.myVariable.getValueObject()).intValue());
        }
        return new Long(((BigInteger)this.myVariable.getValueObject()).longValue());
    }

    @Override
    public boolean isEditorValueValid() {
        return true;
    }

    public void updateEditor() {
        this.myDecimalTF.setText(this.myVariable.getValueString());
        this.TFEdited = true;
        this.setCheckBoxes(this.myDecimalTF.getText());
        this.TFEdited = false;
        this.calculateBinary();
        this.myDecimalLabel.setToolTipText("Binary: " + this.binaryRep);
        this.myDecimalTF.setToolTipText("Binary: " + this.binaryRep);
    }
}

