/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.bitpatternutils.BitPatternValue;
import java.lang.constant.Constable;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

class BitPatternModel
extends DefaultTableModel {
    private static final Class<?>[] types = new Class[]{Integer.class, Boolean.class, Boolean.class};
    private boolean maskIsEditable = false;
    private boolean noMask = false;
    private BitPatternValue myData;
    private DataType myDataType;

    public BitPatternModel(DataType dataType) {
        this.myDataType = dataType;
        this.myData = new BitPatternValue(this.myDataType);
        this.addColumn("Bit pattern ID");
        this.addColumn("Active");
        this.addColumn("Mask");
        for (int i = 0; i < this.myDataType.bitSize(); ++i) {
            Vector<Constable> aRow = new Vector<Constable>();
            aRow.add(Integer.valueOf(i + 1));
            aRow.add(Boolean.valueOf(false));
            aRow.add(Boolean.valueOf(true));
            this.addRow(aRow);
        }
        this.populate(this.myData.getValueAsBitSet(), this.myData.getMaskAsBitSet());
    }

    public void removeMask() {
        this.noMask = true;
        this.setColumnCount(2);
    }

    public void setData(BitPatternValue newData) {
        if (!this.myData.isEqualTo(newData)) {
            this.populate(newData.getValueAsBitSet(), newData.getMaskAsBitSet());
            this.myData.setData(newData.getValue(), newData.getMask());
        }
    }

    public BitPatternValue getData() {
        return this.updateSourceData();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        if (columnIndex == 2) {
            return this.maskEditable();
        }
        return true;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return types[columnIndex];
    }

    public void maskEditable(boolean editable) {
        this.maskIsEditable = editable;
    }

    public boolean maskEditable() {
        return this.maskIsEditable;
    }

    private BitPatternValue updateSourceData() {
        BitSet value = new BitSet(this.myDataType.bitSize());
        BitSet mask = new BitSet(this.myDataType.bitSize());
        for (int i = 0; i < this.myDataType.bitSize(); ++i) {
            if (((Boolean)this.getValueAt(i, 1)).booleanValue()) {
                value.set(i);
            } else {
                value.clear(i);
            }
            if (!this.noMask && ((Boolean)this.getValueAt(i, 2)).booleanValue()) {
                mask.set(i);
                continue;
            }
            mask.clear(i);
        }
        BitPatternValue tmpBPdata = new BitPatternValue(this.myDataType);
        tmpBPdata.setData(value, mask);
        return tmpBPdata;
    }

    private void populate(BitSet value, BitSet mask) {
        for (int i = 0; i < this.myDataType.bitSize(); ++i) {
            this.setValueAt(value.get(i), i, 1);
            if (this.noMask) continue;
            this.setValueAt(mask.get(i), i, 2);
        }
    }
}

