/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.bitpatternutils;

import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.UnsignedLong;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.StatusPanel;
import ericsson.vareditor.documents.AllIntegersDocument;
import ericsson.vareditor.variable.bitpatternutils.BitPatternModel;
import ericsson.vareditor.variable.bitpatternutils.BitPatternValue;
import ericsson.vareditor.variable.bitpatternutils.IDCellRenderer;
import ericsson.vareditor.variable.bitpatternutils.MaskCellRenderer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.math.BigInteger;
import javax.swing.BoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class BitPatternView
extends JPanel
implements KeyListener,
ChangeListener,
TableModelListener {
    public static final String LBL_SERVICE_ID = "Bit pattern ID";
    public static final String LBL_ACTIVE = "Active";
    public static final String LBL_MASK = "Mask";
    public static final String LBL_SELECT_ALL = "Select all";
    public static final String LBL_DESELECT_ALL = "Deselect all";
    private JLabel decimalLabel;
    private JLabel decimalMaskLabel;
    private JTextField decimalValueTF;
    private JTextField decimalMaskValueTF;
    private JLabel emptyFilleL2;
    private JLabel emptyFillerL;
    private JPanel maskPanel;
    private JButton selectAllMaskButton;
    private JButton selectAllValueButton;
    private JScrollPane tableScrollPane;
    private JPanel valuePanel;
    private JTable valueTable;
    private DataType myDataType;
    private BigInteger noneSelected = new BigInteger("0");
    private BitPatternValue myBPValue;
    private Document valueDocument;
    private Document maskDocument;
    private StatusPanel myStatusPanel;

    public BitPatternView(DataType dataType, StatusPanel aStatusPanel) {
        this.myDataType = dataType;
        this.myStatusPanel = aStatusPanel;
        this.myBPValue = new BitPatternValue(dataType);
        this.setupBitsAndDocuments();
        this.initComponents();
        this.setupComponents();
    }

    private void setupBitsAndDocuments() {
        BigInteger maxValue;
        BigInteger minValue;
        switch (this.myDataType) {
            case SHORT: {
                minValue = BigInteger.valueOf(-32768L);
                maxValue = BigInteger.valueOf(32767L);
                break;
            }
            case UNSIGNEDSHORT: {
                minValue = BigInteger.valueOf(0L);
                maxValue = BigInteger.valueOf(65535L);
                break;
            }
            case INTEGER: {
                minValue = BigInteger.valueOf(Integer.MIN_VALUE);
                maxValue = BigInteger.valueOf(Integer.MAX_VALUE);
                break;
            }
            case UNSIGNEDINT: {
                minValue = BigInteger.valueOf(0L);
                maxValue = BigInteger.valueOf(0xFFFFFFFFL);
                break;
            }
            case LONG: {
                minValue = BigInteger.valueOf(Long.MIN_VALUE);
                maxValue = BigInteger.valueOf(Long.MAX_VALUE);
                break;
            }
            case UNSIGNEDLONG: {
                minValue = UnsignedLong.MIN_VALUE;
                maxValue = UnsignedLong.MAX_VALUE;
                break;
            }
            default: {
                throw new IllegalArgumentException(this.myDataType.getTypeName() + " is not supported.");
            }
        }
        this.valueDocument = new AllIntegersDocument(minValue, maxValue, false);
        this.maskDocument = new AllIntegersDocument(minValue, maxValue, false);
        StatusInterface statusHandler = this.createStatusHandler(this.myStatusPanel);
        ((FieldValidation)((Object)this.valueDocument)).setStatusHandler(statusHandler);
        ((FieldValidation)((Object)this.maskDocument)).setStatusHandler(statusHandler);
    }

    private StatusInterface createStatusHandler(final StatusPanel statusPanel) {
        return new StatusInterface(){

            @Override
            public void beep() {
                RmaDefs.getInstance().controlledBeep();
            }

            @Override
            public String getCurrentMessage() {
                return statusPanel.getStatusMsg();
            }

            @Override
            public void printMessage(String msg) {
                statusPanel.setStatusMsg(msg);
            }
        };
    }

    public void setFirstComponentFocus() {
        this.decimalValueTF.requestFocus();
    }

    public void setData(BitPatternValue value) {
        this.populate(value);
    }

    public String getData() {
        return this.myBPValue.getData();
    }

    public void setTitle(String title) {
        ((TitledBorder)this.getBorder()).setTitle(title);
    }

    public void maskEnabled(boolean enabled) {
        if (enabled) {
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(5, 3, 5, 5);
            gbc.anchor = 17;
            gbc.weightx = 1.0;
            this.add((Component)this.maskPanel, gbc);
        } else {
            this.myBPValue.dfltMask();
            this.remove(this.maskPanel);
        }
        ((BitPatternModel)this.valueTable.getModel()).maskEditable(enabled);
    }

    public void populate(BitPatternValue aValue) {
        this.myBPValue.removeChangeListener(this);
        this.valueTable.getModel().removeTableModelListener(this);
        this.decimalValueTF.setText(aValue.getValueWithConversionByDataType().toString());
        this.decimalMaskValueTF.setText(aValue.getMaskWithConversionByDataType().toString());
        ((BitPatternModel)this.valueTable.getModel()).setData(aValue);
        this.myBPValue.setData(aValue.getValue(), aValue.getMask());
        this.updateSelectAllButtons(((BitPatternModel)this.valueTable.getModel()).maskEditable());
        this.myBPValue.addChangeListener(this);
        this.valueTable.getModel().addTableModelListener(this);
    }

    private void initComponents() {
        this.tableScrollPane = new JScrollPane();
        this.valueTable = new JTable();
        this.valuePanel = new JPanel();
        this.decimalLabel = new JLabel();
        this.decimalValueTF = new JTextField();
        this.selectAllValueButton = new JButton();
        this.emptyFillerL = new JLabel();
        this.maskPanel = new JPanel();
        this.decimalMaskLabel = new JLabel();
        this.decimalMaskValueTF = new JTextField();
        this.selectAllMaskButton = new JButton();
        this.emptyFilleL2 = new JLabel();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Bit pattern value"));
        Object[][] tableModelObjectArray = new Object[this.myDataType.bitSize()][3];
        for (int i = 1; i < this.myDataType.bitSize(); ++i) {
            tableModelObjectArray[i][0] = Integer.toString(i);
            tableModelObjectArray[i][1] = null;
            tableModelObjectArray[i][2] = null;
        }
        this.valueTable.setModel(new DefaultTableModel(tableModelObjectArray, new String[]{"Title 1", "Title 2", "Title 3"}));
        this.tableScrollPane.setViewportView(this.valueTable);
        this.tableScrollPane.setMinimumSize(new Dimension(0, 0));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(8, 8, 8, 8);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tableScrollPane, gridBagConstraints);
        this.valuePanel.setLayout(new GridBagLayout());
        this.valuePanel.setBorder(new TitledBorder("Value"));
        this.decimalLabel.setText("Decimal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.valuePanel.add((Component)this.decimalLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.valuePanel.add((Component)this.decimalValueTF, gridBagConstraints);
        this.selectAllValueButton.setText(LBL_SELECT_ALL);
        this.selectAllValueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BitPatternView.this.selectAllValueButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.valuePanel.add((Component)this.selectAllValueButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.valuePanel.add((Component)this.emptyFillerL, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 3);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.valuePanel, gridBagConstraints);
        this.maskPanel.setLayout(new GridBagLayout());
        this.maskPanel.setBorder(new TitledBorder(LBL_MASK));
        this.decimalMaskLabel.setText("Decimal:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.maskPanel.add((Component)this.decimalMaskLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.maskPanel.add((Component)this.decimalMaskValueTF, gridBagConstraints);
        this.selectAllMaskButton.setText(LBL_DESELECT_ALL);
        this.selectAllMaskButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BitPatternView.this.selectAllMaskButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.maskPanel.add((Component)this.selectAllMaskButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.maskPanel.add((Component)this.emptyFilleL2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 3, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.maskPanel, gridBagConstraints);
    }

    private void selectAllMaskButtonActionPerformed(ActionEvent evt) {
        if (this.selectAllMaskButton.getText().equals(LBL_SELECT_ALL)) {
            this.myBPValue.setData(this.myBPValue.getValue(), BitPatternValue.getValueWithAllBitsSet(this.myDataType));
        } else {
            this.myBPValue.setData(this.myBPValue.getValue(), this.noneSelected);
        }
    }

    private void selectAllValueButtonActionPerformed(ActionEvent evt) {
        if (this.selectAllValueButton.getText().equals(LBL_SELECT_ALL)) {
            this.myBPValue.setData(BitPatternValue.getValueWithAllBitsSet(this.myDataType), this.myBPValue.getMask());
        } else {
            this.myBPValue.setData(this.noneSelected, this.myBPValue.getMask());
        }
    }

    private void updateSelectAllButtons(boolean maskEnabled) {
        if (this.myBPValue.getValue().equals(BitPatternValue.getValueWithAllBitsSet(this.myDataType))) {
            this.selectAllValueButton.setText(LBL_DESELECT_ALL);
        } else if (this.myBPValue.getValue().equals(this.noneSelected)) {
            this.selectAllValueButton.setText(LBL_SELECT_ALL);
        }
        if (maskEnabled) {
            if (this.myBPValue.getMask().equals(BitPatternValue.getValueWithAllBitsSet(this.myDataType))) {
                this.selectAllMaskButton.setText(LBL_DESELECT_ALL);
            } else if (this.myBPValue.getMask().equals(this.noneSelected)) {
                this.selectAllMaskButton.setText(LBL_SELECT_ALL);
            }
        }
    }

    private void setupComponents() {
        BitPatternModel model = new BitPatternModel(this.myDataType);
        this.valueTable.setModel(model);
        this.valueTable.getModel().addTableModelListener(this);
        this.valueTable.setDefaultRenderer(Integer.class, new IDCellRenderer());
        this.valueTable.setDefaultRenderer(Boolean.class, new MaskCellRenderer());
        this.decimalValueTF.setColumns(15);
        this.decimalValueTF.addKeyListener(this);
        this.decimalValueTF.setDocument(this.valueDocument);
        this.decimalMaskValueTF.setColumns(15);
        this.decimalMaskValueTF.addKeyListener(this);
        this.decimalMaskValueTF.setDocument(this.maskDocument);
        this.setMinimumSize(this.getPreferredSize());
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getSource() instanceof JTextComponent) {
            JTextComponent theComp = (JTextComponent)ke.getSource();
            if (theComp == this.decimalValueTF) {
                String valueString = this.decimalValueTF.getText();
                if (!this.myBPValue.getValueWithConversionByDataType().toString().equals(valueString) && ((FieldValidation)((Object)this.valueDocument)).isValid(valueString)) {
                    this.myBPValue.setData(new BigInteger(valueString), this.myBPValue.getMask());
                }
            } else if (theComp == this.decimalMaskValueTF) {
                String maskString = this.decimalMaskValueTF.getText();
                if (!this.myBPValue.getMaskWithConversionByDataType().toString().equals(maskString) && ((FieldValidation)((Object)this.maskDocument)).isValid(maskString)) {
                    this.myBPValue.setData(this.myBPValue.getValue(), new BigInteger(maskString));
                }
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        BitPatternValue tmpBPV = (BitPatternValue)e.getSource();
        this.populate(tmpBPV);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        BitPatternValue tmpBPV = ((BitPatternModel)e.getSource()).getData();
        this.populate(tmpBPV);
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    public BoundedRangeModel getScrollModel() {
        return this.tableScrollPane.getVerticalScrollBar().getModel();
    }

    public void setScrollModel(BoundedRangeModel newModel) {
        this.tableScrollPane.getVerticalScrollBar().setModel(newModel);
    }

    public void reset() {
        this.myBPValue.setData("0");
        this.myBPValue.dfltMask();
    }
}

