/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TDFAdditionalDataType;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.xml.Entities;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.documents.StringDocument;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.RangeVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.TypedDropDownVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.CustomTDFAdditionalDataType;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDefs;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldHelper;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldXmlUtil;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalObject;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFDropDownVariable;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import org.w3c.dom.Element;

public final class TreeDefinedField
implements Cloneable {
    private ClassRepository myClassRepository;
    private transient VarTableModel myTableModel;
    private Variable myInputRestrictionNoRangeVariable = TreeDefinedField.createInputRestrictionTypeVariable(EnumSet.of(InputRestrictionType.NONE, InputRestrictionType.ENUMERATION));
    private Variable myInputRestrictionWithRangeVariable = TreeDefinedField.createInputRestrictionTypeVariable(EnumSet.of(InputRestrictionType.NONE, InputRestrictionType.RANGE, InputRestrictionType.ENUMERATION));
    private List<Variable> myAdditionalVarList;
    private List<TDFAdditionalDataType> myAdditionalDataTypeList;
    private List<Variable> myVarList;
    private String myDefaultValue;
    private String myFieldName;
    private DataType myDataType;
    private List<String> myRangeValues;
    private ArrayModel myEnumModel;
    private InputRestrictionType mySimulationType;
    private String myXml;
    private Element myElement;
    private transient Variable myInvalidVar;
    private transient DataItemHandler myVariableHandler = new DataItemHandler();
    private transient TreeDefinedFieldXmlUtil myXmlHelper;
    private transient TreeDefinedFieldHelper myHelper;

    private TreeDefinedField(TreeDefinedField source) {
        this.myClassRepository = source.myClassRepository;
        this.myHelper = source.myHelper;
        this.myAdditionalVarList = source.myAdditionalVarList;
        this.myDefaultValue = source.myDefaultValue;
        this.myDataType = source.myDataType;
        this.mySimulationType = source.mySimulationType;
        this.myFieldName = source.myFieldName;
        this.myAdditionalDataTypeList = source.myAdditionalDataTypeList;
        if (source.myRangeValues != null) {
            this.myRangeValues = new ArrayList<String>();
            for (String o : source.myRangeValues) {
                this.myRangeValues.add(String.valueOf(o));
            }
        }
        if (source.myEnumModel != null) {
            this.myEnumModel = new ArrayModel(source.myEnumModel.toArray(), source.myEnumModel.getColumnNames());
        }
        this.setupVariableList();
    }

    private TreeDefinedField(ClassRepository repository, List<TDFAdditionalDataType> additionalDataTypesList) {
        this.myClassRepository = repository;
        this.myHelper = new TreeDefinedFieldHelper(this.myClassRepository);
        this.myXmlHelper = new TreeDefinedFieldXmlUtil(this.myHelper);
        if (additionalDataTypesList != null) {
            this.myAdditionalDataTypeList = this.removeStandardTypes(additionalDataTypesList);
        }
    }

    public TreeDefinedField(ClassRepository repository, Element fields, List<TDFAdditionalDataType> additionalDataTypesList) {
        this(repository, fields, additionalDataTypesList, null);
    }

    public TreeDefinedField(ClassRepository repository, List<TDFAdditionalObject> additionalList, List<TDFAdditionalDataType> additionalDataTypeList) {
        this(repository, additionalDataTypeList);
        if (additionalList != null) {
            this.createAdditionalVariables(additionalList);
        }
        this.initalizeWithDefaultValues();
    }

    public TreeDefinedField(ClassRepository repository, Element field, List<TDFAdditionalDataType> additionalDataTypeList, List<TDFAdditionalObject> additionalList) {
        this(repository, additionalDataTypeList);
        this.myElement = field;
        this.initializeFromXML(additionalList);
    }

    private List<TDFAdditionalDataType> removeStandardTypes(List<TDFAdditionalDataType> additionalDataTypesList) {
        ArrayList<TDFAdditionalDataType> ret = new ArrayList<TDFAdditionalDataType>(additionalDataTypesList);
        for (TDFAdditionalDataType adt : TreeDefinedFieldDefs.DEFAULT_TDF_TYPES) {
            ret.remove(adt);
        }
        return ret.isEmpty() ? null : Collections.unmodifiableList(ret);
    }

    private Variable selectInputRestrictionVariableBasedOnDataType(DataType dt, InputRestrictionType selected) {
        Variable var = null;
        if (this.inputRestrictionAllowed(dt)) {
            Variable variable = var = this.dataTypeAllowsRange(dt) ? this.myInputRestrictionWithRangeVariable : this.myInputRestrictionNoRangeVariable;
            if (selected != null) {
                var.setDataItem(null);
                var.setValue((Object)selected);
            }
        }
        return var;
    }

    private void createAdditionalVariables(List<TDFAdditionalObject> additionalList) {
        this.myAdditionalVarList = new ArrayList<Variable>();
        for (int i = 0; i < additionalList.size(); ++i) {
            TDFAdditionalObject additionalObject = additionalList.get(i);
            Variable var = this.myHelper.getVariable(additionalObject);
            var.setValue(additionalObject.getDefaultValue());
            this.myAdditionalVarList.add(var);
        }
    }

    private void initializeFromXML(List<TDFAdditionalObject> additionalList) {
        assert (this.myElement != null);
        String tagName = this.myElement.getTagName();
        if (!tagName.equals("Field")) {
            throw new IllegalStateException("Expected <Field> XML element, found: " + tagName);
        }
        this.createVariablesFromXml(this.myElement, additionalList);
    }

    private void createVariablesFromXml(Element fieldElement, List<TDFAdditionalObject> additionalList) {
        if (!fieldElement.hasAttributes()) {
            return;
        }
        this.myFieldName = Entities.XML.unescape(fieldElement.getAttribute("Name"));
        this.myDataType = DataType.lookup(fieldElement.getAttribute("DataType"));
        this.myDefaultValue = Entities.XML.unescape(fieldElement.getAttribute("Default"));
        if (this.myAdditionalDataTypeList == null) {
            this.updateAdditionalDataTypesFromXML(fieldElement);
        }
        this.myAdditionalVarList = this.myXmlHelper.getAdditionalVarsFromXml(fieldElement);
        this.addMissingAdditionalVariables(additionalList);
        if (this.inputRestrictionAllowed(this.myDataType)) {
            Element editComponentElement = TreeDefinedFieldXmlUtil.getEditComponent(fieldElement);
            if (editComponentElement != null) {
                if (this.dataTypeAllowsRange(this.myDataType) && this.isRange(editComponentElement)) {
                    String min = TreeDefinedFieldXmlUtil.getMinValueForRangeEditor(editComponentElement);
                    String max = TreeDefinedFieldXmlUtil.getMaxValueForRangeEditor(editComponentElement);
                    this.myRangeValues = Arrays.asList(min, max);
                    this.mySimulationType = InputRestrictionType.RANGE;
                } else if (this.isEnumeration(editComponentElement)) {
                    ArrayModel enumModel;
                    this.myEnumModel = enumModel = TreeDefinedFieldXmlUtil.getEnumArrayForEditor(editComponentElement, this.myDataType);
                    this.mySimulationType = InputRestrictionType.ENUMERATION;
                }
            } else {
                this.mySimulationType = InputRestrictionType.NONE;
            }
        }
        this.setupVariableList();
    }

    private void addMissingAdditionalVariables(List<TDFAdditionalObject> additionalList) {
        if (additionalList != null && !additionalList.isEmpty()) {
            ArrayList<Variable> missingVarList = new ArrayList<Variable>();
            for (TDFAdditionalObject additional : additionalList) {
                if (!this.isVariableMissing(additional)) continue;
                Variable var = this.myHelper.getVariable(additional);
                var.setValue(additional.getDefaultValue());
                missingVarList.add(var);
            }
            if (this.myAdditionalVarList != null) {
                this.myAdditionalVarList.addAll(missingVarList);
            } else {
                this.myAdditionalVarList = missingVarList;
            }
        }
    }

    private boolean isVariableMissing(TDFAdditionalObject additional) {
        boolean retVal = true;
        if (this.myAdditionalVarList != null && !this.myAdditionalVarList.isEmpty()) {
            for (Variable variable : this.myAdditionalVarList) {
                if (!variable.getTypename().equals(additional.getDataType()) || !variable.getLabel().equals(additional.getName())) continue;
                retVal = false;
                break;
            }
        }
        return retVal;
    }

    private Variable createSimulationVariable(InputRestrictionType type, boolean useSimulationValues) {
        Variable var = null;
        if (type == InputRestrictionType.RANGE) {
            if (useSimulationValues && this.myRangeValues != null) {
                String min = this.myRangeValues.get(0);
                String max = this.myRangeValues.get(1);
                var = this.getSimulationRangeVariable(min, max);
            } else {
                var = this.getSimulationRangeVariable(null, null);
            }
        } else if (type == InputRestrictionType.ENUMERATION) {
            ArrayModel enumModel = useSimulationValues ? this.myEnumModel : TreeDefinedFieldHelper.createEmptyArrayModelOfDataType(this.myDataType);
            var = this.createEnumVariable(enumModel);
        }
        return var;
    }

    private void updateAdditionalDataTypesFromXML(Element fieldElement) {
        Element additionalDataTypeRoot = XMLUtil.getFirstElementNamed("TheAdditionalTDFDataTypes", fieldElement);
        if (additionalDataTypeRoot != null) {
            List<Element> adtList = XMLUtil.getElementNodesNamed("AdditionalDataType", additionalDataTypeRoot.getChildNodes());
            for (Element e : adtList) {
                String dataType = XMLUtil.getFirstTextContent(e);
                if (this.myAdditionalDataTypeList == null) {
                    this.myAdditionalDataTypeList = new ArrayList<TDFAdditionalDataType>();
                }
                this.myAdditionalDataTypeList.add(TDFAdditionalDataType.getByDataType(dataType));
            }
        }
    }

    private boolean isRange(Element element) {
        return element.getAttribute("class").equals("ericsson.ere.gui.util.NumberRangeEditor") || element.getAttribute("Type").equals("Range");
    }

    private boolean isEnumeration(Element element) {
        return element.getAttribute("class").equals("ericsson.ere.gui.util.EnumEditor") || element.getAttribute("Type").equals("Enum");
    }

    private Variable getSimulationRangeVariable(String min, String max) {
        RangeVariable rangeVar = min == null || max == null ? new RangeVariable("Range", this.myDataType.getTypeName(), true) : new RangeVariable("Range", this.myDataType.getTypeName(), min, max, true);
        return rangeVar;
    }

    private void updateDefaultVariableForDataType(TDFAdditionalDataType tdfDataType) {
        Variable defaultVar = this.createDefaultValueVariable(tdfDataType, null);
        if (defaultVar != null) {
            defaultVar.setHelpId(this.getClass().toString());
            VarListUtil.replaceVariableByLabel(this.myVarList, "Default value", defaultVar);
        }
    }

    private void updateInputRestrictionVariableForDataType(DataType dt) {
        VarListUtil.removeVariablesByLabel(this.myVarList, "Input restrictions", "Enumeration", "Range");
        Variable inputRestrictVar = this.selectInputRestrictionVariableBasedOnDataType(dt, InputRestrictionType.NONE);
        if (inputRestrictVar != null) {
            this.myVarList.add(inputRestrictVar);
        }
    }

    private void dataTypeChanged(TDFAdditionalDataType dt) {
        this.myDataType = dt.getNativeDataType();
        this.updateDefaultVariableForDataType(dt);
        this.updateInputRestrictionVariableForDataType(dt.getNativeDataType());
    }

    private ArrayVariable createEnumVariable(ArrayModel enumModel) {
        ArrayVariable var = new ArrayVariable("Enumeration", enumModel, (ValueResolver)this.myDataType);
        var.setAllowEmpty(false);
        return var;
    }

    private void setEnumVariableEditMode(ArrayVariable enumVar, boolean val) {
        enumVar.setEditMode(val ? ArrayVariable.EditMode.PROTECT_OLD : ArrayVariable.EditMode.ALLOW_EDIT);
    }

    private void initalizeWithDefaultValues() {
        this.myFieldName = "";
        this.myDataType = DataType.STRING;
        this.myDefaultValue = "";
        this.mySimulationType = InputRestrictionType.NONE;
        this.myRangeValues = null;
        this.myEnumModel = null;
        this.setupVariableList();
    }

    public void commitValues() {
        ArrayVariable enumVariable;
        this.myFieldName = VarListUtil.getValueStringForName(this.myVarList, "Name");
        TDFAdditionalDataType adt = (TDFAdditionalDataType)VarListUtil.getValueForName(this.myVarList, "Data type");
        this.myDataType = adt.getNativeDataType();
        this.myDefaultValue = XMLUtil.escape(VarListUtil.getValueStringForName(this.myVarList, "Default value"));
        if (this.myDataType == DataType.LONG && this.myDefaultValue.equals("")) {
            this.myDefaultValue = "0";
        }
        this.mySimulationType = (InputRestrictionType)((Object)VarListUtil.getValueForName(this.myVarList, "Input restrictions"));
        RangeVariable rangeVariable = (RangeVariable)VarListUtil.getVariableForName(this.myVarList, "Range");
        if (rangeVariable != null) {
            String min = rangeVariable.getMinValue();
            String max = rangeVariable.getMaxValue();
            this.myRangeValues = Arrays.asList(min, max);
        }
        if ((enumVariable = (ArrayVariable)VarListUtil.getVariableForName(this.myVarList, "Enumeration")) != null) {
            this.myEnumModel = enumVariable.getModel();
        }
        this.createXml();
    }

    private void setupVariableList() {
        StringVariable nameVar = new StringVariable("Name", this.myFieldName, new StringDocument(200L));
        Variable dataTypeVariable = this.createDataTypeVariable(this.myDataType);
        Variable defaultVar = this.createDefaultValueVariable(this.getTypeByDataType(this.myDataType), this.myDefaultValue);
        Variable inputRestrictVar = this.selectInputRestrictionVariableBasedOnDataType(this.myDataType, this.mySimulationType);
        ArrayList<Variable> varList = new ArrayList<Variable>();
        varList.add(nameVar);
        if (this.myAdditionalVarList != null) {
            varList.addAll(this.myAdditionalVarList);
        }
        varList.add(dataTypeVariable);
        varList.add(defaultVar);
        if (inputRestrictVar != null) {
            varList.add(inputRestrictVar);
            Variable simVar = this.createSimulationVariable(this.mySimulationType, true);
            if (simVar != null) {
                varList.add(simVar);
            }
        }
        this.myVarList = varList;
        this.createXml();
    }

    public boolean validateField() {
        FieldDefinition fieldDefinitiontoReturn = this.myClassRepository.getFieldDefinitionByName(this.myFieldName);
        if (fieldDefinitiontoReturn == null) {
            this.myClassRepository.addField(this.myElement);
            return true;
        }
        return false;
    }

    public boolean inputAllowed() {
        boolean allowed = true;
        if (this.myFieldName.trim().equals("")) {
            allowed = false;
            this.myInvalidVar = this.myVarList.get(0);
        } else {
            for (Variable var : this.myVarList) {
                if (var.isValueValid()) continue;
                this.myInvalidVar = var;
                allowed = false;
                break;
            }
        }
        return allowed;
    }

    public Variable getInvalidVariable() {
        return this.myInvalidVar;
    }

    public String toString() {
        return Entities.XML.unescape(this.myFieldName);
    }

    public String toStringForToolTip() {
        StringBuilder valueString = new StringBuilder();
        valueString.append("Name: ");
        valueString.append(Entities.XML.unescape(this.myFieldName));
        valueString.append("  Data type: ");
        valueString.append(this.myDataType.getTypeName());
        valueString.append("  ");
        return valueString.toString();
    }

    public String getXML() {
        if (this.myXml != null && !"".equals(this.myXml)) {
            return this.myXml;
        }
        this.createXml();
        return this.myXml;
    }

    public Element getElement() {
        return this.myElement;
    }

    private void appendAdditionalVariableXMLIfNecessary(StringBuilder xml) {
        if (this.myAdditionalVarList != null && !this.myAdditionalVarList.isEmpty()) {
            xml.append("<Additional>");
            for (Variable var : this.myAdditionalVarList) {
                xml.append("<AdditionalVar Name=\"");
                xml.append(XMLUtil.escape(var.getLabel().toString()));
                xml.append("\" DataType=\"");
                xml.append(XMLUtil.escape(var.getTypename().toString()));
                xml.append("\" Value=\"");
                xml.append(XMLUtil.escape(var.getValueObject().toString()));
                if (var instanceof TDFDropDownVariable) {
                    xml.append("\">");
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    PrintWriter printWriter = new PrintWriter(out);
                    ((DropDownVariable)var).writeXMLVarSpecific(printWriter);
                    printWriter.flush();
                    xml.append(out);
                    xml.append("</AdditionalVar>");
                    continue;
                }
                xml.append("\" />");
            }
            xml.append("</Additional>");
        }
    }

    private void appendAdditionalDataTypeXMLIfNecessary(StringBuilder xml) {
        if (this.myAdditionalDataTypeList != null && this.myAdditionalDataTypeList.size() > 0) {
            xml.append("\n<TheAdditionalTDFDataTypes>");
            for (TDFAdditionalDataType dataType : this.myAdditionalDataTypeList) {
                xml.append("<AdditionalDataType>");
                xml.append(dataType.getDataType());
                xml.append("</AdditionalDataType>");
            }
            xml.append("\n</TheAdditionalTDFDataTypes>");
        }
    }

    private void appendSimulationDataIfNecessary(StringBuilder xml) {
        if (this.mySimulationType == InputRestrictionType.ENUMERATION) {
            if (this.myEnumModel != null && this.myEnumModel.getRowCount() > 0) {
                xml.append("<InputRestriction Type=\"Enum\">");
                for (int i = 0; i < this.myEnumModel.getRowCount(); ++i) {
                    xml.append("<Enum name=\"");
                    xml.append(XMLUtil.escape((String)this.myEnumModel.getValueAt(i, 0)));
                    xml.append("\" value=\"");
                    xml.append(XMLUtil.escape(String.valueOf(this.myEnumModel.getValueAt(i, 1))));
                    xml.append("\" />");
                }
                xml.append("</InputRestriction>");
            }
        } else if (this.mySimulationType == InputRestrictionType.RANGE && this.myRangeValues != null) {
            xml.append("<InputRestriction Type=\"Range\">");
            xml.append("<Range Min=\"");
            xml.append(this.myRangeValues.get(0));
            xml.append("\" Max=\"");
            xml.append(this.myRangeValues.get(1));
            xml.append("\" /></InputRestriction>");
        }
    }

    private void createXml() {
        StringBuilder fieldXml = new StringBuilder();
        StringBuilder additional = new StringBuilder();
        fieldXml.append("<Field Name=\"").append(XMLUtil.escape(this.myFieldName)).append("\"");
        fieldXml.append(" ValueList=\"false\"");
        fieldXml.append(" DataType=\"").append(this.myDataType.getTypeName()).append("\"");
        fieldXml.append(" ParameterType=\"").append("INTERNAL").append("\"");
        fieldXml.append(" AutoConditionMap=\"true\"");
        fieldXml.append(" Default=\"").append(XMLUtil.escape(this.myDefaultValue)).append("\"");
        this.appendSimulationDataIfNecessary(additional);
        this.appendAdditionalVariableXMLIfNecessary(additional);
        this.appendAdditionalDataTypeXMLIfNecessary(additional);
        if (additional.length() == 0) {
            fieldXml.append(" />");
        } else {
            fieldXml.append(">").append(additional.toString());
            fieldXml.append("</Field>");
        }
        try {
            String xml = fieldXml.toString();
            this.myElement = XMLUtil.buildDocumentFromString(xml).getDocumentElement();
            this.myXml = xml;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public VarTableModel createVarTableModel() {
        List<Variable> vars = this.getVarList();
        if (this.myTableModel == null) {
            this.myTableModel = new VarTableModel();
        }
        this.myTableModel.setData(vars);
        return this.myTableModel;
    }

    public List<Variable> getVarList() {
        for (Variable var : this.myVarList) {
            var.setDataItem(this.myVariableHandler);
        }
        return this.myVarList;
    }

    public String getName() {
        return VarListUtil.getValueStringForName(this.myVarList, "Name");
    }

    private boolean dataTypeAllowsRange(DataType dataType) {
        if (dataType == DataType.STRING || dataType == DataType.BCDSTRING || dataType == DataType.BOOLEAN || dataType == DataType.OCTETSTRING) {
            return false;
        }
        if (this.myAdditionalDataTypeList != null) {
            for (TDFAdditionalDataType dt : this.myAdditionalDataTypeList) {
                if (dt.getNativeDataType() != dataType) continue;
                return dt.isRangeAllowed();
            }
        }
        return true;
    }

    private boolean inputRestrictionAllowed(DataType dataType) {
        for (TDFAdditionalDataType dt : this.allTDFTypes()) {
            if (dt.getNativeDataType() != dataType) continue;
            return dt.isEnumAllowed() || dt.isRangeAllowed();
        }
        return false;
    }

    public Object clone() {
        return new TreeDefinedField(this);
    }

    public String getDataType() {
        return this.myDataType.getTypeName();
    }

    public void setReadOnly(boolean readOnly) {
        List<Variable> varList = this.myVarList;
        for (Variable var : varList) {
            if (var instanceof ArrayVariable) {
                this.setEnumVariableEditMode((ArrayVariable)var, readOnly);
                continue;
            }
            var.setAllowEdit(!readOnly);
        }
    }

    private Variable createDefaultValueVariable(TDFAdditionalDataType tdfDataType, String defaultValue) {
        Variable var;
        if (tdfDataType instanceof CustomTDFAdditionalDataType) {
            var = ((CustomTDFAdditionalDataType)tdfDataType).createDefaultValueVariable("Default value", defaultValue, this.myClassRepository);
        } else {
            var = this.myHelper.getVariableOfDataType(tdfDataType.getDataType(), "Default value", null, null, null, false);
            if (defaultValue != null) {
                var.setValue(defaultValue);
            }
        }
        return var;
    }

    private Variable createDataTypeVariable(DataType selected) {
        List<TDFAdditionalDataType> dataTypes = this.allTDFTypes();
        TDFAdditionalDataType adt = this.getTypeByDataType(selected);
        assert (dataTypes.contains(adt)) : "Data type " + selected + " is NOT in the data type list.";
        TDFAdditionalDataType[] items = dataTypes.toArray(new TDFAdditionalDataType[dataTypes.size()]);
        return new TypedDropDownVariable<TDFAdditionalDataType>("Data type", items, adt, new TDFTypeLabeler());
    }

    private static TypedDropDownVariable<InputRestrictionType> createInputRestrictionTypeVariable(EnumSet<InputRestrictionType> types) {
        assert (!types.isEmpty());
        InputRestrictionType[] items = types.toArray(new InputRestrictionType[types.size()]);
        return new TypedDropDownVariable<InputRestrictionType>("Input restrictions", items, new InputRestrictionTypeLabeler());
    }

    private List<TDFAdditionalDataType> allTDFTypes() {
        HashSet<TDFAdditionalDataType> dataTypes = new HashSet<TDFAdditionalDataType>(Arrays.asList(TreeDefinedFieldDefs.DEFAULT_TDF_TYPES));
        if (this.myAdditionalDataTypeList != null) {
            dataTypes.addAll(this.myAdditionalDataTypeList);
        }
        return new ArrayList<TDFAdditionalDataType>(dataTypes);
    }

    private TDFAdditionalDataType getTypeByDataType(DataType dataType) {
        TDFAdditionalDataType type = TDFAdditionalDataType.getByDataType(dataType);
        if (type == null) {
            type = TDFAdditionalDataType.getByDataTypeFromList(dataType, this.myAdditionalDataTypeList);
        }
        return type;
    }

    private class DataItemHandler
    extends DataItemAdapter {
        private DataItemHandler() {
        }

        @Override
        public void setDataItem(Object reference, Object object) {
            boolean listChanged = false;
            if ("Data type".equals(reference)) {
                listChanged = true;
                TDFAdditionalDataType adt = (TDFAdditionalDataType)((Variable)object).getValueObject();
                TreeDefinedField.this.dataTypeChanged(adt);
            } else if ("Input restrictions".equals(reference)) {
                listChanged = true;
                InputRestrictionType type = (InputRestrictionType)((Object)((Variable)object).getValueObject());
                VarListUtil.removeVariablesByLabel((List<Variable>)TreeDefinedField.this.myVarList, "Enumeration", "Range");
                Variable simVar = TreeDefinedField.this.createSimulationVariable(type, false);
                if (simVar != null) {
                    TreeDefinedField.this.myVarList.add(simVar);
                }
            }
            if (listChanged && TreeDefinedField.this.myTableModel != null) {
                TreeDefinedField.this.myTableModel.setData(TreeDefinedField.this.getVarList());
            }
        }
    }

    private static class InputRestrictionTypeLabeler
    implements TypedDropDownVariable.ItemLabeler<InputRestrictionType> {
        private InputRestrictionTypeLabeler() {
        }

        @Override
        public String getDisplayStringFor(InputRestrictionType object, int index) {
            switch (object) {
                case NONE: {
                    return "NO DATA";
                }
                case RANGE: {
                    return "RANGE";
                }
                case ENUMERATION: {
                    return "ENUMERATION";
                }
            }
            throw new AssertionError((Object)("Unhandled type: " + (Object)((Object)object)));
        }
    }

    private static class TDFTypeLabeler
    implements TypedDropDownVariable.ItemLabeler<TDFAdditionalDataType> {
        private TDFTypeLabeler() {
        }

        @Override
        public String getDisplayStringFor(TDFAdditionalDataType object, int index) {
            return object.getTypeDescription();
        }
    }

    private static enum InputRestrictionType {
        NONE,
        RANGE,
        ENUMERATION;

    }
}

