/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.treedefinedfields.AbstractTDFAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;

public class TreeDefinedFieldDeleteAction
extends AbstractTDFAction {
    private static final String MSG_CONFIRM_DELETION = "Are you sure you want to delete this field?\nThis can not be undone.";
    private static final String DELETE_ICON_FILE = "new_delete.gif";
    private ListSelectionModel mySelectionModel;

    public TreeDefinedFieldDeleteAction(ClassRepository repository, List<TreeDefinedField> model, ListSelectionModel selectionModel) {
        super(repository, model, null, null);
        this.mySelectionModel = selectionModel;
        this.putValue("SmallIcon", RmaDefs.getImageIcon(DELETE_ICON_FILE));
        this.putValue("ShortDescription", "Delete the selected 'Tree Defined Field'");
        this.putValue("Name", "Delete value");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreeDefinedField tdf;
        int index = this.mySelectionModel.getMinSelectionIndex();
        if (index != -1 && !this.isTDFInUse(tdf = (TreeDefinedField)this.myModel.get(index)) && this.confirmDeletion(e, MSG_CONFIRM_DELETION)) {
            this.myModel.remove(index);
        }
    }

    protected boolean confirmDeletion(ActionEvent e, String confirmationText) {
        int option = JOptionPane.showConfirmDialog(this.findOwnerWindow(e.getSource()), confirmationText, UIManager.getString("OptionPane.titleText"), 0);
        return option == 0;
    }
}

