/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.ere.selectiontree.structures.treedefinedfields.TDFAdditionalDataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.treedefinedfields.AbstractTDFAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDialog;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldEditDialog;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalObject;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.ListSelectionModel;

public class TreeDefinedFieldEditAction
extends AbstractTDFAction {
    private static final String EDIT_ICON_FILE = "new_edit.gif";
    private ListSelectionModel mySelectionModel;

    public TreeDefinedFieldEditAction(ClassRepository repository, List<TreeDefinedField> model, ListSelectionModel selectionModel, List<TDFAdditionalObject> additionalVarList, List<TDFAdditionalDataType> additionalDataTypeList) {
        super(repository, model, additionalVarList, additionalDataTypeList);
        this.mySelectionModel = selectionModel;
        this.putValue("SmallIcon", RmaDefs.getImageIcon(EDIT_ICON_FILE));
        this.putValue("ShortDescription", "Edit the selected 'Tree Defined Field'");
        this.putValue("Name", "Edit value");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int index = this.mySelectionModel.getMinSelectionIndex();
        if (index != -1) {
            TreeDefinedField edited;
            TreeDefinedField selectedObject = (TreeDefinedField)this.myModel.get(index);
            TreeDefinedFieldDialog dialog = this.createDialog(e);
            dialog.setTitle("Tree Defined Fields - Edit");
            boolean readOnly = this.isTDFInUse(selectedObject);
            dialog.setupValuesForEditing((TreeDefinedField)selectedObject.clone(), readOnly);
            if (dialog.showDialog() && !this.areTreeDefinedFieldsEqual(selectedObject, edited = dialog.getTreeDefinedField())) {
                this.myModel.set(index, dialog.getTreeDefinedField());
            }
        }
    }

    private boolean areTreeDefinedFieldsEqual(TreeDefinedField tdf1, TreeDefinedField tdf2) {
        String xml1 = tdf1.getXML();
        String xml2 = tdf2.getXML();
        return xml1.equals(xml2);
    }

    protected TreeDefinedFieldDialog createDialog(ActionEvent e) {
        TreeDefinedFieldEditDialog dialog = new TreeDefinedFieldEditDialog(this.myRepository, this.findOwnerWindow(e.getSource()), this.myAdditionalVarList, this.myAdditionalDataTypesList);
        return dialog;
    }
}

