/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.ere.selectiontree.structures.treedefinedfields.TDFAdditionalDataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDialog;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDialogPanel;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalObject;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JDialog;

public class TreeDefinedFieldEditDialog
extends JDialog
implements ActionListener,
TreeDefinedFieldDialog {
    private static final String MSG_INVALID_VALUE = "Value of field not allowed";
    protected static final String LBL_DIALOG_TITLE = "Tree Defined Field";
    protected static final String LBL_TITLED_BORDER = "Set up your field";
    protected static final int ACTION_ADD = 0;
    protected static final int ACTION_EDIT = 1;
    private List<TDFAdditionalObject> myAdditionalVarList;
    private List<TDFAdditionalDataType> myAdditionalDataTypes;
    private String myOriginalName;
    private ClassRepository myClassRepository;
    private TreeDefinedField myTreeDefinedField;
    private boolean myDidCloseViaOk = false;

    public TreeDefinedFieldEditDialog(ClassRepository cr, Window window, List<TDFAdditionalObject> additionalVars, List<TDFAdditionalDataType> additionalDataTypes) {
        super(window, LBL_DIALOG_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setName("TreeDefinedFieldEditDialog");
        this.myClassRepository = cr;
        this.myAdditionalVarList = additionalVars;
        this.myAdditionalDataTypes = additionalDataTypes;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean shouldClose = true;
        if (e.getActionCommand().equals("OK")) {
            this.myTreeDefinedField.commitValues();
            if (this.myTreeDefinedField.inputAllowed()) {
                String newName = this.myTreeDefinedField.getName();
                if (this.nameAlreadyExists(newName)) {
                    DialogFactory.getErrorDialog(MSG_INVALID_VALUE, "The name '" + newName + "' has been used before.\nPlease select a new name.");
                    shouldClose = false;
                }
            } else {
                DialogFactory.getErrorDialog(MSG_INVALID_VALUE, "The value of " + this.myTreeDefinedField.getInvalidVariable().getLabel() + " is invalid.\nPlease correct this and try again.");
                shouldClose = false;
            }
            this.myDidCloseViaOk = shouldClose;
        }
        this.setVisible(!shouldClose);
    }

    private boolean nameAlreadyExists(String newName) {
        if (this.myOriginalName != null && this.myOriginalName.equals(newName)) {
            return false;
        }
        FieldDefinition field = this.myClassRepository.getFieldDefinitionByName(newName);
        return field != null;
    }

    @Override
    public TreeDefinedField getTreeDefinedField() {
        return this.myTreeDefinedField;
    }

    @Override
    public void setupValuesForEditing(TreeDefinedField editObject, boolean readOnly) {
        this.myTreeDefinedField = editObject;
        this.myOriginalName = this.myTreeDefinedField.getName();
        this.setupPanel(readOnly);
    }

    @Override
    public void setupValuesForAdding() {
        this.myTreeDefinedField = new TreeDefinedField(this.myClassRepository, this.myAdditionalVarList, this.myAdditionalDataTypes);
        this.setupPanel(false);
    }

    private void setupPanel(boolean readOnly) {
        TreeDefinedFieldDialogPanel panel = new TreeDefinedFieldDialogPanel(LBL_TITLED_BORDER);
        panel.init(this.myTreeDefinedField, readOnly);
        panel.addOkActionListener(this);
        panel.addCancelActionListener(this);
        this.add(panel);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    @Override
    public boolean showDialog() {
        this.setVisible(true);
        return this.myDidCloseViaOk;
    }
}

