/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.ere.selectiontree.interfaces.TDFAdditionalDataTypesForStructure;
import com.ericsson.ere.selectiontree.structures.treedefinedfields.TDFAdditionalDataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.ratingrules.nodes.TDFChangeEvent;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.util.ArrayListModel;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.AbstractTDFAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldAddAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDeleteAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldEditAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldEditMenu;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldExportAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldImportAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldModelHandler;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldSupport;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldViewAction;
import ericsson.vareditor.variable.treedefinedfields.tdfvariables.TDFAdditionalObject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.dom.Element;

public class TreeDefinedFieldEditor
extends AbstractPanelVariableEditor {
    public static final String VALUE_SEP = ",";
    private JPanel myButtonPanel = new JPanel();
    private JList myList;
    private ArrayListModel<TreeDefinedField> myModel = new ArrayListModel();
    private TreeDefinedFieldEditMenu myPopupMenu;
    private AbstractTDFAction addAction;
    private AbstractTDFAction editAction;
    private AbstractTDFAction viewAction;
    private TreeDefinedFieldDeleteAction deleteAction;
    private AbstractTDFAction importAction;
    private AbstractTDFAction exportAction;
    private ClassRepository myClassRepository;
    protected static final String LBL_DIALOG_TITLE = "Tree Defined Fields";
    private List<String> myTDFsInUseList = new ArrayList<String>();
    private TSTariffStructure myTariffStructureRoot;
    private List<TDFAdditionalDataType> myAdditionalDataTypesList;
    private List<TDFAdditionalObject> myAdditionalVarList;

    @Deprecated
    public TreeDefinedFieldEditor(ClassRepository repository, Element element) {
        this(repository, element, null);
    }

    public TreeDefinedFieldEditor(ClassRepository repository, Element element, TSTariffStructure treeRoot) {
        this.myClassRepository = repository;
        ClassProfile profile = null;
        if (treeRoot != null) {
            profile = treeRoot.getClassProfile();
            this.myTariffStructureRoot = treeRoot;
        }
        if (profile instanceof TreeDefinedFieldSupport) {
            this.myAdditionalVarList = ((TreeDefinedFieldSupport)((Object)profile)).getAdditionalTDFVariables();
        }
        if (profile instanceof TDFAdditionalDataTypesForStructure) {
            this.myAdditionalDataTypesList = ((TDFAdditionalDataTypesForStructure)((Object)profile)).getAdditionalTDFDataTypes();
        }
        this.init(element);
        TreeDefinedFieldModelHandler handler = new TreeDefinedFieldModelHandler(this, this.myClassRepository, this.myModel, this.myTariffStructureRoot, new ChainModelHandler());
        this.myModel.addListDataListener(handler);
        this.setVisible(true);
    }

    private void init(Element fieldElement) {
        this.createValuesInListFromXml(fieldElement);
        this.buildComponents();
    }

    private void createValuesInListFromXml(Element fieldsXml) {
        if (fieldsXml != null) {
            List<Element> fieldList = XMLUtil.getElementNodesNamed("Field", fieldsXml.getChildNodes());
            for (int i = 0; i < fieldList.size(); ++i) {
                Element currentField = fieldList.get(i);
                TreeDefinedField t = this.createTreeDefinedField(currentField, this.myAdditionalDataTypesList);
                this.myModel.add(t);
            }
        }
    }

    private TreeDefinedField createTreeDefinedField(Element field, List<TDFAdditionalDataType> addDtList) {
        TreeDefinedField tdf = new TreeDefinedField(this.myClassRepository, field, addDtList);
        return tdf;
    }

    private boolean isTDFInUse(String varName) {
        for (String name : this.myTDFsInUseList) {
            if (!varName.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    private boolean nonTDFFieldExistsInClassRepository(String name) {
        boolean nameClash = false;
        FieldDefinition def = this.myClassRepository.getFieldDefinitionByName(name);
        if (def != null) {
            nameClash = !"INTERNAL".equals(def.getParameterType());
        }
        return nameClash;
    }

    private void buildComponents() {
        this.setLayout(new BorderLayout());
        this.myList = new JList(this.myModel){

            @Override
            public String getToolTipText(MouseEvent e) {
                int row = this.locationToIndex(e.getPoint());
                String text = "";
                if (row > -1) {
                    Object o = TreeDefinedFieldEditor.this.myModel.getElementAt(row);
                    TreeDefinedField field = (TreeDefinedField)o;
                    text = TreeDefinedFieldEditor.this.nonTDFFieldExistsInClassRepository(field.getName()) ? "Error: A field named '" + field.getName() + "' already exists in the service." : field.toStringForToolTip();
                }
                return text;
            }
        };
        this.myList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
                JComponent c = (JComponent)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
                String fieldName = String.valueOf(value);
                if (TreeDefinedFieldEditor.this.nonTDFFieldExistsInClassRepository(fieldName)) {
                    c.setBackground(Color.red);
                }
                return c;
            }
        });
        this.myList.setVisibleRowCount(5);
        this.myList.setFixedCellHeight(18);
        this.myList.addMouseListener(new MouseHandler());
        this.myList.addListSelectionListener(new SelectionHandler());
        this.add((Component)new JScrollPane(this.myList), "Center");
        this.initActions();
        this.createButtonPanel();
        this.add((Component)this.myButtonPanel, "South");
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.myPopupMenu = new TreeDefinedFieldEditMenu(this.addAction, this.viewAction, null, this.editAction, this.deleteAction);
    }

    private void createButtonPanel() {
        JButton addButton = new JButton(this.addAction);
        JButton editButton = new JButton(this.editAction);
        JButton viewButton = new JButton(this.viewAction);
        JButton deleteButton = new JButton(this.deleteAction);
        JButton importButton = new JButton(this.importAction);
        JButton exportButton = new JButton(this.exportAction);
        addButton.setName("TDFEditor.JButton.add");
        editButton.setName("TDFEditor.JButton.edit");
        viewButton.setName("TDFEditor.JButton.view");
        deleteButton.setName("TDFEditor.JButton.delete");
        importButton.setName("TDFEditor.JButton.import");
        exportButton.setName("TDFEditor.JButton.export");
        addButton.setHideActionText(true);
        editButton.setHideActionText(true);
        viewButton.setHideActionText(true);
        deleteButton.setHideActionText(true);
        importButton.setHideActionText(true);
        exportButton.setHideActionText(true);
        this.myButtonPanel.setLayout(new GridBagLayout());
        this.myButtonPanel.add((Component)addButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.myButtonPanel.add((Component)viewButton, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.myButtonPanel.add((Component)editButton, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.myButtonPanel.add((Component)deleteButton, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.myButtonPanel.add((Component)importButton, new GridBagConstraints(4, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0));
        this.myButtonPanel.add((Component)exportButton, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(1, 0, 1, 4), 0, 0));
    }

    private void initActions() {
        this.addAction = new TreeDefinedFieldAddAction(this.myClassRepository, this.myModel, this.myAdditionalVarList, this.myAdditionalDataTypesList);
        this.editAction = new TreeDefinedFieldEditAction(this.myClassRepository, this.myModel, this.myList.getSelectionModel(), this.myAdditionalVarList, this.myAdditionalDataTypesList);
        this.deleteAction = new TreeDefinedFieldDeleteAction(this.myClassRepository, this.myModel, this.myList.getSelectionModel());
        this.viewAction = new TreeDefinedFieldViewAction(this.myClassRepository, this.myModel, this.myList.getSelectionModel());
        this.importAction = new TreeDefinedFieldImportAction(this.myClassRepository, this.myModel, this.myAdditionalVarList, this.myAdditionalDataTypesList);
        this.exportAction = new TreeDefinedFieldExportAction(this.myClassRepository, this.myModel);
        this.editAction.setTDFsInUseList(this.myTDFsInUseList);
        this.deleteAction.setTDFsInUseList(this.myTDFsInUseList);
        this.importAction.setTDFsInUseList(this.myTDFsInUseList);
        InputMap input = this.myList.getInputMap(0);
        ActionMap action = this.myList.getActionMap();
        input.put(KeyStroke.getKeyStroke(127, 0, false), "delete");
        action.put("delete", this.deleteAction);
    }

    private void maybeViewPopupMenu(MouseEvent e) {
        int selRow;
        JList source = (JList)e.getSource();
        this.enableActions(source);
        if (!this.myPopupMenu.isVisible() && (selRow = source.locationToIndex(new Point(e.getX(), e.getY()))) != -1) {
            source.setSelectedIndex(selRow);
        }
        if (e.isPopupTrigger()) {
            this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void enableActions(int noSelectedItem, boolean allowDelete) {
        this.addAction.setEnabled(true);
        this.viewAction.setEnabled(noSelectedItem == 1);
        this.editAction.setEnabled(noSelectedItem == 1);
        this.deleteAction.setEnabled(allowDelete && noSelectedItem > 0);
    }

    @Override
    public boolean isEditorValueValid() {
        boolean valid = true;
        for (TreeDefinedField field : this.myModel) {
            FieldDefinition classDef = this.myClassRepository.getFieldDefinitionByName(field.getName());
            if (classDef == null || classDef.getParameterType().equals("INTERNAL")) continue;
            valid = false;
            break;
        }
        return valid;
    }

    @Override
    public Element getEditorValue() {
        Element root;
        String valueString = this.createXMLString();
        try {
            root = XMLUtil.buildDocumentFromString(valueString).getDocumentElement();
        }
        catch (Exception e) {
            root = null;
        }
        return root;
    }

    public String createXMLString() {
        StringBuilder tdfXML = new StringBuilder();
        tdfXML.append("<Fields");
        int size = this.myModel.size();
        if (size == 0) {
            tdfXML.append("/>");
        } else {
            tdfXML.append(">\n");
            for (int i = 0; i < this.myModel.size(); ++i) {
                if (i > 0) {
                    tdfXML.append("\n");
                }
                if (this.myModel.get(i) == null) continue;
                TreeDefinedField field = this.myModel.get(i);
                tdfXML.append(field.getXML());
            }
            tdfXML.append("\n</Fields>");
        }
        return tdfXML.toString();
    }

    @Override
    public Component getEditorComponent(Variable intVariable) {
        this.myList.clearSelection();
        return this;
    }

    public Component getComponent() {
        return this;
    }

    public void removeObject(Object editObject) {
        this.myClassRepository.removeTreeDefinedField(((TreeDefinedField)editObject).getName());
        this.fireDataChanged();
    }

    private void searchForTreeDefinedFields() {
        String[] tdfsInUse;
        this.myTDFsInUseList.clear();
        if (this.myTariffStructureRoot != null && (tdfsInUse = this.myTariffStructureRoot.getTreeDefinedFieldInUse()) != null && tdfsInUse.length > 0) {
            for (int i = 0; i < tdfsInUse.length; ++i) {
                String tdf = tdfsInUse[i];
                if (tdf == null) continue;
                this.myTDFsInUseList.add(tdfsInUse[i]);
            }
        }
    }

    private void enableActions(JList list) {
        TreeDefinedField selectedField = (TreeDefinedField)list.getSelectedValue();
        boolean inUse = selectedField != null ? this.isTDFInUse(selectedField.getName()) : false;
        this.enableActions(list.getSelectedValues().length, !inUse);
    }

    private class ChainModelHandler
    implements ListDataListener {
        private ChainModelHandler() {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            TreeDefinedFieldEditor.this.fireDataChanged();
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            TreeDefinedFieldEditor.this.searchForTreeDefinedFields();
            TreeDefinedFieldEditor.this.fireDataChanged();
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            TreeDefinedFieldEditor.this.myTariffStructureRoot.notifyTDFChange(new TDFChangeEvent(TreeDefinedFieldEditor.this, TDFChangeEvent.TDFChangeType.REMOVED));
            TreeDefinedFieldEditor.this.fireDataChanged();
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JList source = (JList)e.getSource();
            int index = source.getSelectedIndex();
            if (index != -1) {
                if (e.getClickCount() == 2) {
                    if (TreeDefinedFieldEditor.this.viewAction.isEnabled()) {
                        ActionEvent ev = new ActionEvent(source, 1001, null);
                        TreeDefinedFieldEditor.this.viewAction.actionPerformed(ev);
                    }
                } else {
                    TreeDefinedFieldEditor.this.maybeViewPopupMenu(e);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            TreeDefinedFieldEditor.this.maybeViewPopupMenu(e);
        }
    }

    private class SelectionHandler
    implements ListSelectionListener {
        private SelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            JList source = (JList)e.getSource();
            TreeDefinedFieldEditor.this.searchForTreeDefinedFields();
            TreeDefinedFieldEditor.this.enableActions(source);
        }
    }
}

