/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.ere.gui.wizard.WizardFactory;
import com.ericsson.ere.gui.wizard.WizardView;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Transformer;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.vareditor.variable.treedefinedfields.AbstractTDFAction;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;

public class TreeDefinedFieldExportAction
extends AbstractTDFAction {
    private static final String EXPORT_ICON_FILE = "export1_16.png";
    static Transformer<TreeDefinedField, String> TDF_NAME_TRANSFORMER = new Transformer<TreeDefinedField, String>(){

        @Override
        public String transform(TreeDefinedField input) {
            return input.getName();
        }
    };

    public TreeDefinedFieldExportAction(ClassRepository repository, List<TreeDefinedField> model) {
        super(repository, model, null, null);
        this.putValue("SmallIcon", RmaDefs.getImageIcon(EXPORT_ICON_FILE));
        this.putValue("ShortDescription", "Export 'Tree Defined Field'(s) to file");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.myModel.size() > 0) {
            Map<String, TreeDefinedField> existingTDFs = CollectionUtils.createMap(this.myModel, TDF_NAME_TRANSFORMER);
            this.exportFields(existingTDFs);
        }
    }

    protected void exportFields(Map<String, TreeDefinedField> existingTDFs) {
        WizardView tDialog = WizardFactory.createTDFExportWizard(existingTDFs);
        tDialog.run();
    }
}

