/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Transformer;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.ratingrules.nodes.TDFChangeEvent;
import ericsson.ere.gui.ratingrules.nodes.TSNotificationReceiver;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.w3c.dom.Element;

public class TreeDefinedFieldModelHandler
implements ListDataListener {
    private final TSNotificationReceiver myReceiver;
    private final Object mySource;
    private final ListDataListener myChainedListener;
    private final ClassRepository myRepository;
    private final List<TreeDefinedField> myModel;
    private static final Transformer<FieldDefinition, String> TDF_NAME_EXTRACTOR = new Transformer<FieldDefinition, String>(){

        @Override
        public String transform(FieldDefinition input) {
            String name = null;
            if ("INTERNAL".equals(input.getParameterType())) {
                name = input.getFieldName();
            }
            return name;
        }
    };

    public TreeDefinedFieldModelHandler(Object source, ClassRepository repository, List<TreeDefinedField> model, TSNotificationReceiver receiver, ListDataListener chainedListener) {
        if (source == null || repository == null || model == null) {
            throw new IllegalArgumentException("Source, class repository and TDF model must be specified.");
        }
        this.mySource = source;
        this.myReceiver = receiver;
        this.myChainedListener = chainedListener;
        this.myRepository = repository;
        this.myModel = model;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        String name = this.addTDFToRepository(e);
        if (this.myReceiver != null) {
            this.myReceiver.notifyTDFChange(new TDFChangeEvent(this.mySource, TDFChangeEvent.TDFChangeType.MODIFIED, name));
        }
        if (this.myChainedListener != null) {
            this.myChainedListener.contentsChanged(e);
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        String name = this.addTDFToRepository(e);
        if (this.myReceiver != null) {
            this.myReceiver.notifyTDFChange(new TDFChangeEvent(this.mySource, TDFChangeEvent.TDFChangeType.ADDED, name));
        }
        if (this.myChainedListener != null) {
            this.myChainedListener.intervalAdded(e);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        Set<String> tdfNames = this.getTreeDefinedFieldNames();
        for (TreeDefinedField tdf : this.myModel) {
            tdfNames.remove(tdf.getName());
        }
        for (String removed : tdfNames) {
            this.myRepository.removeTreeDefinedField(removed);
        }
        if (this.myReceiver != null) {
            String[] nameArray = tdfNames.toArray(new String[tdfNames.size()]);
            this.myReceiver.notifyTDFChange(new TDFChangeEvent(this.mySource, TDFChangeEvent.TDFChangeType.REMOVED, nameArray));
        }
        if (this.myChainedListener != null) {
            this.myChainedListener.intervalRemoved(e);
        }
    }

    private Set<String> getTreeDefinedFieldNames() {
        List<FieldDefinition> fields = this.myRepository.getFieldDefinitions();
        return new HashSet<String>(CollectionUtils.transform(fields, TDF_NAME_EXTRACTOR));
    }

    private String addTDFToRepository(ListDataEvent e) {
        int index = e.getIndex0();
        TreeDefinedField tdf = this.myModel.get(index);
        Element fieldElement = tdf.getElement();
        FieldDefinition fd = this.myRepository.addField(fieldElement);
        return fd.getFieldName();
    }
}

