/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.treedefinedfields;

import ericsson.ere.datatype.DataType;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.ArrayVariable;
import ericsson.vareditor.variable.RangeVariable;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedField;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableModel;

public class TreeDefinedFieldViewDialog
extends JDialog
implements TreeDefinedFieldDialog {
    protected static final String LBL_DIALOG_TITLE = "Tree Defined Field - View";
    private TreeDefinedField myTreeDefinedField;

    public TreeDefinedFieldViewDialog(Window window) {
        super(window, LBL_DIALOG_TITLE, Dialog.ModalityType.APPLICATION_MODAL);
        this.setResizable(false);
        this.setLayout(new GridBagLayout());
    }

    private void setupValues() {
        String tdfName;
        assert (this.myTreeDefinedField != null);
        JPanel contentPanel = new JPanel(new GridBagLayout());
        JTable simulationDataTable = null;
        JTable viewTable = new JTable();
        viewTable.setName("TreeDefinedFieldViewDialog.JTable.viewTable");
        viewTable.setShowGrid(false);
        viewTable.setEnabled(false);
        DefaultTableModel viewTableModel = (DefaultTableModel)viewTable.getModel();
        viewTableModel.addColumn("");
        viewTableModel.addColumn("");
        contentPanel.add((Component)viewTable, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        List<Variable> varList = this.myTreeDefinedField.getVarList();
        int i = 0;
        int indexForSimData = -1;
        for (i = 0; i < varList.size(); ++i) {
            Variable var = varList.get(i);
            Object valueObject = var.getValueObject();
            DataType dataType = DataType.fromObjectClass(valueObject);
            String valueString = dataType != null ? dataType.makeDisplayString(valueObject) : var.getValueString();
            viewTableModel.addRow(new String[]{var.getLabel(), valueString});
            if (!var.getLabel().equals("Input restrictions")) continue;
            indexForSimData = i;
            break;
        }
        if (indexForSimData != -1 && !varList.get(indexForSimData).getValueString().equals("NO DATA")) {
            DefaultTableModel simTableModel;
            simulationDataTable = new JTable();
            simulationDataTable.setEnabled(false);
            if (varList.get(indexForSimData).getValueString().equals("RANGE")) {
                simTableModel = (DefaultTableModel)simulationDataTable.getModel();
                simTableModel.addColumn("");
                simTableModel.addColumn("");
                RangeVariable rVar = (RangeVariable)varList.get(indexForSimData + 1);
                simTableModel.addRow(new String[]{"Min", rVar.getMinValue()});
                simTableModel.addRow(new String[]{"Max", rVar.getMaxValue()});
            } else if (varList.get(indexForSimData).getValueString().equals("ENUMERATION")) {
                simTableModel = (DefaultTableModel)simulationDataTable.getModel();
                simTableModel.addColumn("Name");
                simTableModel.addColumn("Value");
                ArrayVariable value = (ArrayVariable)varList.get(indexForSimData + 1);
                ArrayModel enumModel = value.getModel();
                if (enumModel != null) {
                    for (int ii = 0; ii < enumModel.getRowCount(); ++ii) {
                        simTableModel.addRow(new String[]{enumModel.getValueAt(ii, 0).toString(), enumModel.getValueAt(ii, 1).toString()});
                    }
                }
            }
            JLabel simLabel = new JLabel("Input restrictions");
            simLabel.setFont(new Font("Arial", 1, 11));
            contentPanel.add((Component)simLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 16, 1, new Insets(5, 5, 5, 0), 0, 0));
            contentPanel.add((Component)simulationDataTable, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        if ((tdfName = varList.get(0).getValueString()).length() > 70) {
            String subString2;
            String subString1;
            if (tdfName.length() > 130) {
                subString1 = tdfName.substring(0, 60);
                subString2 = tdfName.substring(61, 120);
                String subString3 = tdfName.substring(121, tdfName.length());
                tdfName = subString1 + "\n" + subString2 + "\n" + subString3;
            } else {
                subString1 = tdfName.substring(0, 60);
                subString2 = tdfName.substring(61, tdfName.length());
                tdfName = subString1 + "\n" + subString2;
            }
        }
        JTextArea nameLabel = new JTextArea("Tree Defined Field - " + tdfName);
        nameLabel.setEditable(false);
        nameLabel.setOpaque(false);
        nameLabel.setFont(new Font("Arial", 1, 12));
        this.add((Component)nameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setPreferredSize(new Dimension(300, 250));
        scrollPane.setVerticalScrollBarPolicy(20);
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.createButtonPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 14, 0, new Insets(10, 0, 10, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private JPanel createButtonPanel() {
        JPanel pan = new JPanel(new GridBagLayout());
        JButton closeButton = new JButton("Close");
        closeButton.setPreferredSize(new Dimension(80, 25));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TreeDefinedFieldViewDialog.this.setVisible(false);
            }
        });
        GridBagConstraints con = new GridBagConstraints();
        con.gridx = 0;
        con.gridy = 0;
        con.anchor = 14;
        con.insets = new Insets(0, 0, 0, 10);
        pan.add((Component)closeButton, con);
        return pan;
    }

    @Override
    public TreeDefinedField getTreeDefinedField() {
        return this.myTreeDefinedField;
    }

    @Override
    public void setupValuesForAdding() {
        throw new UnsupportedOperationException("Not supported for this type of dialog.");
    }

    @Override
    public void setupValuesForEditing(TreeDefinedField editObject, boolean readOnly) {
        this.myTreeDefinedField = editObject;
        this.setupValues();
    }

    @Override
    public boolean showDialog() {
        this.setVisible(true);
        return true;
    }
}

