/*
 * Decompiled with CFR 0.152.
 */
package iso.std.iso._20022.tech.xsd;

import com.ericsson.em.validators.IsAddress;
import com.ericsson.em.validators.IsGeographicalName;
import com.ericsson.em.validators.IsPostalCode;
import com.ericsson.em.validators.Length;
import com.ericsson.em.validators.NoNullElements;
import iso.std.iso._20022.tech.xsd.AddressLine;
import iso.std.iso._20022.tech.xsd.AddressType2Code;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PostalAddress1", propOrder={"adrTp", "adrLine", "strtNm", "bldgNb", "pstCd", "twnNm", "ctrySubDvsn", "ctry"})
public class PostalAddress1
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="AdrTp")
    protected AddressType2Code adrTp;
    @Valid
    @NoNullElements
    @XmlElement(name="AdrLine", type=AddressLine.class)
    protected List<AddressLine> adrLine;
    @IsAddress
    @Length(max=128)
    @XmlElement(name="StrtNm")
    protected String strtNm;
    @IsAddress
    @Length(max=16)
    @XmlElement(name="BldgNb")
    protected String bldgNb;
    @IsPostalCode
    @Length(max=64)
    @XmlElement(name="PstCd")
    protected String pstCd;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="TwnNm")
    protected String twnNm;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="CtrySubDvsn")
    protected String ctrySubDvsn;
    @IsGeographicalName
    @Length(max=64)
    @XmlElement(name="Ctry")
    protected String ctry;

    public AddressType2Code getAdrTp() {
        return this.adrTp;
    }

    public void setAdrTp(AddressType2Code value) {
        this.adrTp = value;
    }

    public List<AddressLine> getAdrLine() {
        if (this.adrLine == null) {
            this.adrLine = new ArrayList<AddressLine>();
        }
        return this.adrLine;
    }

    public List<String> getAddressLineStrings() {
        ArrayList<String> addressLines = new ArrayList<String>();
        for (AddressLine line : this.getAdrLine()) {
            addressLines.add(line.getAddressLine());
        }
        return Collections.unmodifiableList(addressLines);
    }

    public void addAddressLine(String addressLine) {
        if (addressLine != null) {
            this.getAdrLine().add(new AddressLine(addressLine));
        }
    }

    public String getStrtNm() {
        return this.strtNm;
    }

    public void setStrtNm(String value) {
        this.strtNm = value;
    }

    public String getBldgNb() {
        return this.bldgNb;
    }

    public void setBldgNb(String value) {
        this.bldgNb = value;
    }

    public String getPstCd() {
        return this.pstCd;
    }

    public void setPstCd(String value) {
        this.pstCd = value;
    }

    public String getTwnNm() {
        return this.twnNm;
    }

    public void setTwnNm(String value) {
        this.twnNm = value;
    }

    public String getCtrySubDvsn() {
        return this.ctrySubDvsn;
    }

    public void setCtrySubDvsn(String value) {
        this.ctrySubDvsn = value;
    }

    public String getCtry() {
        return this.ctry;
    }

    public void setCtry(String value) {
        this.ctry = value;
    }
}

